/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Lists;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ClientSuggestionProvider
implements SharedSuggestionProvider {
    private final ClientPacketListener connection;
    private final Minecraft minecraft;
    private int pendingSuggestionsId = -1;
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestionsFuture;

    public ClientSuggestionProvider(ClientPacketListener pConnection, Minecraft pMinecraft) {
        this.connection = pConnection;
        this.minecraft = pMinecraft;
    }

    @Override
    public Collection<String> getOnlinePlayerNames() {
        ArrayList list = Lists.newArrayList();
        for (PlayerInfo playerinfo : this.connection.getOnlinePlayers()) {
            list.add(playerinfo.getProfile().getName());
        }
        return list;
    }

    @Override
    public Collection<String> getSelectedEntities() {
        return this.minecraft.hitResult != null && this.minecraft.hitResult.getType() == HitResult.Type.ENTITY ? Collections.singleton(((EntityHitResult)this.minecraft.hitResult).getEntity().getStringUUID()) : Collections.emptyList();
    }

    @Override
    public Collection<String> getAllTeams() {
        return this.connection.getLevel().getScoreboard().getTeamNames();
    }

    @Override
    public Collection<ResourceLocation> getAvailableSoundEvents() {
        return this.minecraft.getSoundManager().getAvailableSounds();
    }

    @Override
    public Stream<ResourceLocation> getRecipeNames() {
        return this.connection.getRecipeManager().getRecipeIds();
    }

    @Override
    public boolean hasPermission(int pLevel) {
        LocalPlayer localplayer = this.minecraft.player;
        return localplayer != null ? localplayer.hasPermissions(pLevel) : pLevel == 0;
    }

    @Override
    public CompletableFuture<Suggestions> suggestRegistryElements(ResourceKey<? extends Registry<?>> p_212429_, SharedSuggestionProvider.ElementSuggestionType p_212430_, SuggestionsBuilder p_212431_, CommandContext<?> p_212432_) {
        return this.registryAccess().registry(p_212429_).map(p_212427_ -> {
            this.suggestRegistryElements((Registry<?>)p_212427_, p_212430_, p_212431_);
            return p_212431_.buildFuture();
        }).orElseGet(() -> this.customSuggestion(p_212432_));
    }

    @Override
    public CompletableFuture<Suggestions> customSuggestion(CommandContext<?> p_212423_) {
        if (this.pendingSuggestionsFuture != null) {
            this.pendingSuggestionsFuture.cancel(false);
        }
        this.pendingSuggestionsFuture = new CompletableFuture();
        int i = ++this.pendingSuggestionsId;
        this.connection.send(new ServerboundCommandSuggestionPacket(i, p_212423_.getInput()));
        return this.pendingSuggestionsFuture;
    }

    private static String prettyPrint(double pDoubleValue) {
        return String.format(Locale.ROOT, "%.2f", pDoubleValue);
    }

    private static String prettyPrint(int pDoubleValue) {
        return Integer.toString(pDoubleValue);
    }

    @Override
    public Collection<SharedSuggestionProvider.TextCoordinates> getRelevantCoordinates() {
        HitResult hitresult = this.minecraft.hitResult;
        if (hitresult != null && hitresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)hitresult).getBlockPos();
            return Collections.singleton(new SharedSuggestionProvider.TextCoordinates(ClientSuggestionProvider.prettyPrint(blockpos.getX()), ClientSuggestionProvider.prettyPrint(blockpos.getY()), ClientSuggestionProvider.prettyPrint(blockpos.getZ())));
        }
        return SharedSuggestionProvider.super.getRelevantCoordinates();
    }

    @Override
    public Collection<SharedSuggestionProvider.TextCoordinates> getAbsoluteCoordinates() {
        HitResult hitresult = this.minecraft.hitResult;
        if (hitresult != null && hitresult.getType() == HitResult.Type.BLOCK) {
            Vec3 vec3 = hitresult.getLocation();
            return Collections.singleton(new SharedSuggestionProvider.TextCoordinates(ClientSuggestionProvider.prettyPrint(vec3.x), ClientSuggestionProvider.prettyPrint(vec3.y), ClientSuggestionProvider.prettyPrint(vec3.z)));
        }
        return SharedSuggestionProvider.super.getAbsoluteCoordinates();
    }

    @Override
    public Set<ResourceKey<Level>> levels() {
        return this.connection.levels();
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.connection.registryAccess();
    }

    public void completeCustomSuggestions(int pTransaction, Suggestions pResult) {
        if (pTransaction == this.pendingSuggestionsId) {
            this.pendingSuggestionsFuture.complete(pResult);
            this.pendingSuggestionsFuture = null;
            this.pendingSuggestionsId = -1;
        }
    }
}

