/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.resolver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mojang.blocklist.BlockListSupplier;
import java.util.Objects;
import java.util.ServiceLoader;
import net.minecraft.client.multiplayer.resolver.ResolvedServerAddress;
import net.minecraft.client.multiplayer.resolver.ServerAddress;

public interface AddressCheck {
    public boolean isAllowed(ResolvedServerAddress var1);

    public boolean isAllowed(ServerAddress var1);

    public static AddressCheck createFromService() {
        ImmutableList immutablelist = (ImmutableList)Streams.stream(ServiceLoader.load(BlockListSupplier.class)).map(BlockListSupplier::createBlockList).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        return new AddressCheck(){

            @Override
            public boolean isAllowed(ResolvedServerAddress p_171835_) {
                String s = p_171835_.getHostName();
                String s1 = p_171835_.getHostIp();
                return immutablelist.stream().noneMatch(p_171841_ -> p_171841_.test(s) || p_171841_.test(s1));
            }

            @Override
            public boolean isAllowed(ServerAddress p_171837_) {
                String s = p_171837_.getHost();
                return immutablelist.stream().noneMatch(p_171844_ -> p_171844_.test(s));
            }
        };
    }
}

