/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.resolver;

import java.net.InetSocketAddress;

public interface ResolvedServerAddress {
    public String getHostName();

    public String getHostIp();

    public int getPort();

    public InetSocketAddress asInetSocketAddress();

    public static ResolvedServerAddress from(InetSocketAddress pInetSocketAddress) {
        return new ResolvedServerAddress(){

            @Override
            public String getHostName() {
                return pInetSocketAddress.getAddress().getHostName();
            }

            @Override
            public String getHostIp() {
                return pInetSocketAddress.getAddress().getHostAddress();
            }

            @Override
            public int getPort() {
                return pInetSocketAddress.getPort();
            }

            @Override
            public InetSocketAddress asInetSocketAddress() {
                return pInetSocketAddress;
            }
        };
    }
}

