/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.resolver;

import com.google.common.net.HostAndPort;
import com.mojang.logging.LogUtils;
import java.net.IDN;
import org.slf4j.Logger;

public final class ServerAddress {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HostAndPort hostAndPort;
    private static final ServerAddress INVALID = new ServerAddress(HostAndPort.fromParts((String)"server.invalid", (int)25565));

    public ServerAddress(String pHost, int pPort) {
        this(HostAndPort.fromParts((String)pHost, (int)pPort));
    }

    private ServerAddress(HostAndPort pHostAndPort) {
        this.hostAndPort = pHostAndPort;
    }

    public String getHost() {
        try {
            return IDN.toASCII(this.hostAndPort.getHost());
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return "";
        }
    }

    public int getPort() {
        return this.hostAndPort.getPort();
    }

    public static ServerAddress parseString(String pIp) {
        if (pIp == null) {
            return INVALID;
        }
        try {
            HostAndPort hostandport = HostAndPort.fromString((String)pIp).withDefaultPort(25565);
            return hostandport.getHost().isEmpty() ? INVALID : new ServerAddress(hostandport);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            LOGGER.info("Failed to parse URL {}", (Object)pIp, (Object)illegalargumentexception);
            return INVALID;
        }
    }

    public static boolean isValidAddress(String pHostAndPort) {
        try {
            HostAndPort hostandport = HostAndPort.fromString((String)pHostAndPort);
            String s = hostandport.getHost();
            if (!s.isEmpty()) {
                IDN.toASCII(s);
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    static int parsePort(String pPort) {
        try {
            return Integer.parseInt(pPort.trim());
        }
        catch (Exception exception) {
            return 25565;
        }
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther instanceof ServerAddress ? this.hostAndPort.equals((Object)((ServerAddress)pOther).hostAndPort) : false;
    }

    public int hashCode() {
        return this.hostAndPort.hashCode();
    }
}

