/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class AttackSweepParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    AttackSweepParticle(ClientLevel pLevel, double pX, double p_105548_, double pY, double p_105550_, SpriteSet pZ) {
        super(pLevel, pX, p_105548_, pY, 0.0, 0.0, 0.0);
        float f;
        this.sprites = pZ;
        this.lifetime = 4;
        this.rCol = f = this.random.nextFloat() * 0.6f + 0.4f;
        this.gCol = f;
        this.bCol = f;
        this.quadSize = 1.0f - (float)p_105550_ * 0.5f;
        this.setSpriteFromAge(pZ);
    }

    @Override
    public int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_105580_, double pY, double p_105582_, double pZ, double p_105584_) {
            return new AttackSweepParticle(pLevel, pX, p_105580_, pY, p_105582_, this.sprites);
        }
    }
}

