/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class CampfireSmokeParticle
extends TextureSheetParticle {
    CampfireSmokeParticle(ClientLevel pLevel, double pX, double p_105858_, double pY, double p_105860_, double pZ, double p_105862_, boolean pXSpeed) {
        super(pLevel, pX, p_105858_, pY);
        this.scale(3.0f);
        this.setSize(0.25f, 0.25f);
        this.lifetime = pXSpeed ? this.random.nextInt(50) + 280 : this.random.nextInt(50) + 80;
        this.gravity = 3.0E-6f;
        this.xd = p_105860_;
        this.yd = pZ + (double)(this.random.nextFloat() / 500.0f);
        this.zd = p_105862_;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && !(this.alpha <= 0.0f)) {
            this.xd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime - 60 && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
        } else {
            this.remove();
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class CosyProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public CosyProvider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_105892_, double pY, double p_105894_, double pZ, double p_105896_) {
            CampfireSmokeParticle campfiresmokeparticle = new CampfireSmokeParticle(pLevel, pX, p_105892_, pY, p_105894_, pZ, p_105896_, false);
            campfiresmokeparticle.setAlpha(0.9f);
            campfiresmokeparticle.pickSprite(this.sprites);
            return campfiresmokeparticle;
        }
    }

    public static class SignalProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public SignalProvider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_105913_, double pY, double p_105915_, double pZ, double p_105917_) {
            CampfireSmokeParticle campfiresmokeparticle = new CampfireSmokeParticle(pLevel, pX, p_105913_, pY, p_105915_, pZ, p_105917_, true);
            campfiresmokeparticle.setAlpha(0.95f);
            campfiresmokeparticle.pickSprite(this.sprites);
            return campfiresmokeparticle;
        }
    }
}

