/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class CritParticle
extends TextureSheetParticle {
    CritParticle(ClientLevel p_105919_, double p_105920_, double p_105921_, double p_105922_, double p_105923_, double p_105924_, double p_105925_) {
        super(p_105919_, p_105920_, p_105921_, p_105922_, 0.0, 0.0, 0.0);
        float f;
        this.friction = 0.7f;
        this.gravity = 0.5f;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += p_105923_ * 0.4;
        this.yd += p_105924_ * 0.4;
        this.zd += p_105925_ * 0.4;
        this.rCol = f = (float)(Math.random() * (double)0.3f + (double)0.6f);
        this.gCol = f;
        this.bCol = f;
        this.quadSize *= 0.75f;
        this.lifetime = Math.max((int)(6.0 / (Math.random() * 0.8 + 0.6)), 1);
        this.hasPhysics = false;
        this.tick();
    }

    @Override
    public float getQuadSize(float pScaleFactor) {
        return this.quadSize * Mth.clamp(((float)this.age + pScaleFactor) / (float)this.lifetime * 32.0f, 0.0f, 1.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.gCol *= 0.96f;
        this.bCol *= 0.9f;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class DamageIndicatorProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public DamageIndicatorProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_105955_, double pY, double p_105957_, double pZ, double p_105959_) {
            CritParticle critparticle = new CritParticle(pLevel, pX, p_105955_, pY, p_105957_, pZ + 1.0, p_105959_);
            critparticle.setLifetime(20);
            critparticle.pickSprite(this.sprite);
            return critparticle;
        }
    }

    public static class MagicProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public MagicProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_105976_, double pY, double p_105978_, double pZ, double p_105980_) {
            CritParticle critparticle = new CritParticle(pLevel, pX, p_105976_, pY, p_105978_, pZ, p_105980_);
            critparticle.rCol *= 0.3f;
            critparticle.gCol *= 0.8f;
            critparticle.pickSprite(this.sprite);
            return critparticle;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_105997_, double pY, double p_105999_, double pZ, double p_106001_) {
            CritParticle critparticle = new CritParticle(pLevel, pX, p_105997_, pY, p_105999_, pZ, p_106001_);
            critparticle.pickSprite(this.sprite);
            return critparticle;
        }
    }
}

