/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class DragonBreathParticle
extends TextureSheetParticle {
    private static final int COLOR_MIN = 11993298;
    private static final int COLOR_MAX = 14614777;
    private static final float COLOR_MIN_RED = 0.7176471f;
    private static final float COLOR_MIN_GREEN = 0.0f;
    private static final float COLOR_MIN_BLUE = 0.8235294f;
    private static final float COLOR_MAX_RED = 0.8745098f;
    private static final float COLOR_MAX_GREEN = 0.0f;
    private static final float COLOR_MAX_BLUE = 0.9764706f;
    private boolean hasHitGround;
    private final SpriteSet sprites;

    DragonBreathParticle(ClientLevel pLevel, double pX, double p_106007_, double pY, double p_106009_, double pZ, double p_106011_, SpriteSet pXSpeed) {
        super(pLevel, pX, p_106007_, pY);
        this.friction = 0.96f;
        this.xd = p_106009_;
        this.yd = pZ;
        this.zd = p_106011_;
        this.rCol = Mth.nextFloat(this.random, 0.7176471f, 0.8745098f);
        this.gCol = Mth.nextFloat(this.random, 0.0f, 0.0f);
        this.bCol = Mth.nextFloat(this.random, 0.8235294f, 0.9764706f);
        this.quadSize *= 0.75f;
        this.lifetime = (int)(20.0 / ((double)this.random.nextFloat() * 0.8 + 0.2));
        this.hasHitGround = false;
        this.hasPhysics = false;
        this.sprites = pXSpeed;
        this.setSpriteFromAge(pXSpeed);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
            if (this.onGround) {
                this.yd = 0.0;
                this.hasHitGround = true;
            }
            if (this.hasHitGround) {
                this.yd += 0.002;
            }
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            this.xd *= (double)this.friction;
            this.zd *= (double)this.friction;
            if (this.hasHitGround) {
                this.yd *= (double)this.friction;
            }
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public float getQuadSize(float pScaleFactor) {
        return this.quadSize * Mth.clamp(((float)this.age + pScaleFactor) / (float)this.lifetime * 32.0f, 0.0f, 1.0f);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106043_, double pY, double p_106045_, double pZ, double p_106047_) {
            return new DragonBreathParticle(pLevel, pX, p_106043_, pY, p_106045_, pZ, p_106047_, this.sprites);
        }
    }
}

