/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class DripParticle
extends TextureSheetParticle {
    private final Fluid type;
    protected boolean isGlowing;

    DripParticle(ClientLevel pLevel, double pX, double p_106053_, double pY, Fluid p_106055_) {
        super(pLevel, pX, p_106053_, pY);
        this.setSize(0.01f, 0.01f);
        this.gravity = 0.06f;
        this.type = p_106055_;
    }

    protected Fluid getType() {
        return this.type;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public int getLightColor(float pPartialTick) {
        return this.isGlowing ? 240 : super.getLightColor(pPartialTick);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.postMoveUpdate();
            if (!this.removed) {
                this.xd *= (double)0.98f;
                this.yd *= (double)0.98f;
                this.zd *= (double)0.98f;
                BlockPos blockpos = new BlockPos(this.x, this.y, this.z);
                FluidState fluidstate = this.level.getFluidState(blockpos);
                if (fluidstate.getType() == this.type && this.y < (double)((float)blockpos.getY() + fluidstate.getHeight(this.level, blockpos))) {
                    this.remove();
                }
            }
        }
    }

    protected void preMoveUpdate() {
        if (this.lifetime-- <= 0) {
            this.remove();
        }
    }

    protected void postMoveUpdate() {
    }

    static class CoolingDripHangParticle
    extends DripHangParticle {
        CoolingDripHangParticle(ClientLevel p_106068_, double p_106069_, double p_106070_, double p_106071_, Fluid p_106072_, ParticleOptions p_106073_) {
            super(p_106068_, p_106069_, p_106070_, p_106071_, p_106072_, p_106073_);
        }

        @Override
        protected void preMoveUpdate() {
            this.rCol = 1.0f;
            this.gCol = 16.0f / (float)(40 - this.lifetime + 16);
            this.bCol = 4.0f / (float)(40 - this.lifetime + 8);
            super.preMoveUpdate();
        }
    }

    static class DripHangParticle
    extends DripParticle {
        private final ParticleOptions fallingParticle;

        DripHangParticle(ClientLevel pLevel, double pX, double p_106087_, double pY, Fluid p_106089_, ParticleOptions pZ) {
            super(pLevel, pX, p_106087_, pY, p_106089_);
            this.fallingParticle = pZ;
            this.gravity *= 0.02f;
            this.lifetime = 40;
        }

        @Override
        protected void preMoveUpdate() {
            if (this.lifetime-- <= 0) {
                this.remove();
                this.level.addParticle(this.fallingParticle, this.x, this.y, this.z, this.xd, this.yd, this.zd);
            }
        }

        @Override
        protected void postMoveUpdate() {
            this.xd *= 0.02;
            this.yd *= 0.02;
            this.zd *= 0.02;
        }
    }

    static class DripLandParticle
    extends DripParticle {
        DripLandParticle(ClientLevel p_106102_, double p_106103_, double p_106104_, double p_106105_, Fluid p_106106_) {
            super(p_106102_, p_106103_, p_106104_, p_106105_, p_106106_);
            this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        }
    }

    static class DripstoneFallAndLandParticle
    extends FallAndLandParticle {
        DripstoneFallAndLandParticle(ClientLevel p_171930_, double p_171931_, double p_171932_, double p_171933_, Fluid p_171934_, ParticleOptions p_171935_) {
            super(p_171930_, p_171931_, p_171932_, p_171933_, p_171934_, p_171935_);
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.landParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                SoundEvent soundevent = this.getType() == Fluids.LAVA ? SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA : SoundEvents.POINTED_DRIPSTONE_DRIP_WATER;
                float f = Mth.randomBetween(this.random, 0.3f, 1.0f);
                this.level.playLocalSound(this.x, this.y, this.z, soundevent, SoundSource.BLOCKS, f, 1.0f, false);
            }
        }
    }

    public static class DripstoneLavaFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public DripstoneLavaFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_171953_, double pY, double p_171955_, double pZ, double p_171957_) {
            DripstoneFallAndLandParticle dripparticle = new DripstoneFallAndLandParticle(pLevel, pX, p_171953_, pY, (Fluid)Fluids.LAVA, ParticleTypes.LANDING_LAVA);
            dripparticle.setColor(1.0f, 0.2857143f, 0.083333336f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class DripstoneLavaHangProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public DripstoneLavaHangProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_171974_, double pY, double p_171976_, double pZ, double p_171978_) {
            CoolingDripHangParticle dripparticle = new CoolingDripHangParticle(pLevel, pX, p_171974_, pY, Fluids.LAVA, ParticleTypes.FALLING_DRIPSTONE_LAVA);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class DripstoneWaterFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public DripstoneWaterFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_171995_, double pY, double p_171997_, double pZ, double p_171999_) {
            DripstoneFallAndLandParticle dripparticle = new DripstoneFallAndLandParticle(pLevel, pX, p_171995_, pY, (Fluid)Fluids.WATER, ParticleTypes.SPLASH);
            dripparticle.setColor(0.2f, 0.3f, 1.0f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class DripstoneWaterHangProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public DripstoneWaterHangProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172016_, double pY, double p_172018_, double pZ, double p_172020_) {
            DripHangParticle dripparticle = new DripHangParticle(pLevel, pX, p_172016_, pY, Fluids.WATER, ParticleTypes.FALLING_DRIPSTONE_WATER);
            dripparticle.setColor(0.2f, 0.3f, 1.0f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    static class FallAndLandParticle
    extends FallingParticle {
        protected final ParticleOptions landParticle;

        FallAndLandParticle(ClientLevel pLevel, double pX, double p_106118_, double pY, Fluid p_106120_, ParticleOptions pZ) {
            super(pLevel, pX, p_106118_, pY, p_106120_);
            this.landParticle = pZ;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.landParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
            }
        }
    }

    static class FallingParticle
    extends DripParticle {
        FallingParticle(ClientLevel p_106132_, double p_106133_, double p_106134_, double p_106135_, Fluid p_106136_) {
            this(p_106132_, p_106133_, p_106134_, p_106135_, p_106136_, (int)(64.0 / (Math.random() * 0.8 + 0.2)));
        }

        FallingParticle(ClientLevel pLevel, double pX, double p_172024_, double pY, Fluid p_172026_, int pZ) {
            super(pLevel, pX, p_172024_, pY, p_172026_);
            this.lifetime = pZ;
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
            }
        }
    }

    static class HoneyFallAndLandParticle
    extends FallAndLandParticle {
        HoneyFallAndLandParticle(ClientLevel p_106146_, double p_106147_, double p_106148_, double p_106149_, Fluid p_106150_, ParticleOptions p_106151_) {
            super(p_106146_, p_106147_, p_106148_, p_106149_, p_106150_, p_106151_);
        }

        @Override
        protected void postMoveUpdate() {
            if (this.onGround) {
                this.remove();
                this.level.addParticle(this.landParticle, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                float f = Mth.randomBetween(this.random, 0.3f, 1.0f);
                this.level.playLocalSound(this.x, this.y, this.z, SoundEvents.BEEHIVE_DRIP, SoundSource.BLOCKS, f, 1.0f, false);
            }
        }
    }

    public static class HoneyFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public HoneyFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106177_, double pY, double p_106179_, double pZ, double p_106181_) {
            HoneyFallAndLandParticle dripparticle = new HoneyFallAndLandParticle(pLevel, pX, p_106177_, pY, Fluids.EMPTY, ParticleTypes.LANDING_HONEY);
            dripparticle.gravity = 0.01f;
            dripparticle.setColor(0.582f, 0.448f, 0.082f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class HoneyHangProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public HoneyHangProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106198_, double pY, double p_106200_, double pZ, double p_106202_) {
            DripHangParticle dripparticle$driphangparticle = new DripHangParticle(pLevel, pX, p_106198_, pY, Fluids.EMPTY, ParticleTypes.FALLING_HONEY);
            dripparticle$driphangparticle.gravity *= 0.01f;
            dripparticle$driphangparticle.lifetime = 100;
            dripparticle$driphangparticle.setColor(0.622f, 0.508f, 0.082f);
            dripparticle$driphangparticle.pickSprite(this.sprite);
            return dripparticle$driphangparticle;
        }
    }

    public static class HoneyLandProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public HoneyLandProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106219_, double pY, double p_106221_, double pZ, double p_106223_) {
            DripLandParticle dripparticle = new DripLandParticle(pLevel, pX, p_106219_, pY, Fluids.EMPTY);
            dripparticle.lifetime = (int)(128.0 / (Math.random() * 0.8 + 0.2));
            dripparticle.setColor(0.522f, 0.408f, 0.082f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class LavaFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public LavaFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106240_, double pY, double p_106242_, double pZ, double p_106244_) {
            FallAndLandParticle dripparticle = new FallAndLandParticle(pLevel, pX, p_106240_, pY, (Fluid)Fluids.LAVA, ParticleTypes.LANDING_LAVA);
            dripparticle.setColor(1.0f, 0.2857143f, 0.083333336f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class LavaHangProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public LavaHangProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106261_, double pY, double p_106263_, double pZ, double p_106265_) {
            CoolingDripHangParticle dripparticle$coolingdriphangparticle = new CoolingDripHangParticle(pLevel, pX, p_106261_, pY, Fluids.LAVA, ParticleTypes.FALLING_LAVA);
            dripparticle$coolingdriphangparticle.pickSprite(this.sprite);
            return dripparticle$coolingdriphangparticle;
        }
    }

    public static class LavaLandProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public LavaLandProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106282_, double pY, double p_106284_, double pZ, double p_106286_) {
            DripLandParticle dripparticle = new DripLandParticle(pLevel, pX, p_106282_, pY, Fluids.LAVA);
            dripparticle.setColor(1.0f, 0.2857143f, 0.083333336f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class NectarFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public NectarFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106303_, double pY, double p_106305_, double pZ, double p_106307_) {
            FallingParticle dripparticle = new FallingParticle(pLevel, pX, p_106303_, pY, Fluids.EMPTY);
            dripparticle.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
            dripparticle.gravity = 0.007f;
            dripparticle.setColor(0.92f, 0.782f, 0.72f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class ObsidianTearFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public ObsidianTearFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106324_, double pY, double p_106326_, double pZ, double p_106328_) {
            FallAndLandParticle dripparticle = new FallAndLandParticle(pLevel, pX, p_106324_, pY, Fluids.EMPTY, ParticleTypes.LANDING_OBSIDIAN_TEAR);
            dripparticle.isGlowing = true;
            dripparticle.gravity = 0.01f;
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class ObsidianTearHangProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public ObsidianTearHangProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106345_, double pY, double p_106347_, double pZ, double p_106349_) {
            DripHangParticle dripparticle$driphangparticle = new DripHangParticle(pLevel, pX, p_106345_, pY, Fluids.EMPTY, ParticleTypes.FALLING_OBSIDIAN_TEAR);
            dripparticle$driphangparticle.isGlowing = true;
            dripparticle$driphangparticle.gravity *= 0.01f;
            dripparticle$driphangparticle.lifetime = 100;
            dripparticle$driphangparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle$driphangparticle.pickSprite(this.sprite);
            return dripparticle$driphangparticle;
        }
    }

    public static class ObsidianTearLandProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public ObsidianTearLandProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106366_, double pY, double p_106368_, double pZ, double p_106370_) {
            DripLandParticle dripparticle = new DripLandParticle(pLevel, pX, p_106366_, pY, Fluids.EMPTY);
            dripparticle.isGlowing = true;
            dripparticle.lifetime = (int)(28.0 / (Math.random() * 0.8 + 0.2));
            dripparticle.setColor(0.51171875f, 0.03125f, 0.890625f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class SporeBlossomFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;
        private final Random random;

        public SporeBlossomFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
            this.random = new Random();
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172045_, double pY, double p_172047_, double pZ, double p_172049_) {
            int i = (int)(64.0f / Mth.randomBetween(this.random, 0.1f, 0.9f));
            FallingParticle dripparticle = new FallingParticle(pLevel, pX, p_172045_, pY, Fluids.EMPTY, i);
            dripparticle.gravity = 0.005f;
            dripparticle.setColor(0.32f, 0.5f, 0.22f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class WaterFallProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public WaterFallProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106387_, double pY, double p_106389_, double pZ, double p_106391_) {
            FallAndLandParticle dripparticle = new FallAndLandParticle(pLevel, pX, p_106387_, pY, (Fluid)Fluids.WATER, ParticleTypes.SPLASH);
            dripparticle.setColor(0.2f, 0.3f, 1.0f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }

    public static class WaterHangProvider
    implements ParticleProvider<SimpleParticleType> {
        protected final SpriteSet sprite;

        public WaterHangProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106408_, double pY, double p_106410_, double pZ, double p_106412_) {
            DripHangParticle dripparticle = new DripHangParticle(pLevel, pX, p_106408_, pY, Fluids.WATER, ParticleTypes.FALLING_WATER);
            dripparticle.setColor(0.2f, 0.3f, 1.0f);
            dripparticle.pickSprite(this.sprite);
            return dripparticle;
        }
    }
}

