/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.util.Mth;

public class DustParticleBase<T extends DustParticleOptionsBase>
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected DustParticleBase(ClientLevel pLevel, double pX, double p_172096_, double pY, double p_172098_, double pZ, double p_172100_, T pXSpeed, SpriteSet p_172102_) {
        super(pLevel, pX, p_172096_, pY, p_172098_, pZ, p_172100_);
        this.friction = 0.96f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = p_172102_;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        float f = this.random.nextFloat() * 0.4f + 0.6f;
        this.rCol = this.randomizeColor(((DustParticleOptionsBase)pXSpeed).getColor().x(), f);
        this.gCol = this.randomizeColor(((DustParticleOptionsBase)pXSpeed).getColor().y(), f);
        this.bCol = this.randomizeColor(((DustParticleOptionsBase)pXSpeed).getColor().z(), f);
        this.quadSize *= 0.75f * ((DustParticleOptionsBase)pXSpeed).getScale();
        int i = (int)(8.0 / (this.random.nextDouble() * 0.8 + 0.2));
        this.lifetime = (int)Math.max((float)i * ((DustParticleOptionsBase)pXSpeed).getScale(), 1.0f);
        this.setSpriteFromAge(p_172102_);
    }

    protected float randomizeColor(float pCoordMultiplier, float pMultiplier) {
        return (this.random.nextFloat() * 0.2f + 0.8f) * pCoordMultiplier * pMultiplier;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public float getQuadSize(float pScaleFactor) {
        return this.quadSize * Mth.clamp(((float)this.age + pScaleFactor) / (float)this.lifetime * 32.0f, 0.0f, 1.0f);
    }

    @Override
    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }
}

