/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class EnchantmentTableParticle
extends TextureSheetParticle {
    private final double xStart;
    private final double yStart;
    private final double zStart;

    EnchantmentTableParticle(ClientLevel p_106464_, double p_106465_, double p_106466_, double p_106467_, double p_106468_, double p_106469_, double p_106470_) {
        super(p_106464_, p_106465_, p_106466_, p_106467_);
        this.xd = p_106468_;
        this.yd = p_106469_;
        this.zd = p_106470_;
        this.xStart = p_106465_;
        this.yStart = p_106466_;
        this.zStart = p_106467_;
        this.xo = p_106465_ + p_106468_;
        this.yo = p_106466_ + p_106469_;
        this.zo = p_106467_ + p_106470_;
        this.x = this.xo;
        this.y = this.yo;
        this.z = this.zo;
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.2f);
        float f = this.random.nextFloat() * 0.6f + 0.4f;
        this.rCol = 0.9f * f;
        this.gCol = 0.9f * f;
        this.bCol = f;
        this.hasPhysics = false;
        this.lifetime = (int)(Math.random() * 10.0) + 30;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public void move(double pX, double p_106483_, double pY) {
        this.setBoundingBox(this.getBoundingBox().move(pX, p_106483_, pY));
        this.setLocationFromBoundingbox();
    }

    @Override
    public int getLightColor(float pPartialTick) {
        int i = super.getLightColor(pPartialTick);
        float f = (float)this.age / (float)this.lifetime;
        f *= f;
        f *= f;
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((k += (int)(f * 15.0f * 16.0f)) > 240) {
            k = 240;
        }
        return j | k << 16;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            float f = (float)this.age / (float)this.lifetime;
            f = 1.0f - f;
            float f1 = 1.0f - f;
            f1 *= f1;
            f1 *= f1;
            this.x = this.xStart + this.xd * (double)f;
            this.y = this.yStart + this.yd * (double)f - (double)(f1 * 1.2f);
            this.z = this.zStart + this.zd * (double)f;
        }
    }

    public static class NautilusProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public NautilusProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106504_, double pY, double p_106506_, double pZ, double p_106508_) {
            EnchantmentTableParticle enchantmenttableparticle = new EnchantmentTableParticle(pLevel, pX, p_106504_, pY, p_106506_, pZ, p_106508_);
            enchantmenttableparticle.pickSprite(this.sprite);
            return enchantmenttableparticle;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106525_, double pY, double p_106527_, double pZ, double p_106529_) {
            EnchantmentTableParticle enchantmenttableparticle = new EnchantmentTableParticle(pLevel, pX, p_106525_, pY, p_106527_, pZ, p_106529_);
            enchantmenttableparticle.pickSprite(this.sprite);
            return enchantmenttableparticle;
        }
    }
}

