/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class ExplodeParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected ExplodeParticle(ClientLevel pLevel, double pX, double p_106578_, double pY, double p_106580_, double pZ, double p_106582_, SpriteSet pXSpeed) {
        super(pLevel, pX, p_106578_, pY);
        float f;
        this.gravity = -0.1f;
        this.friction = 0.9f;
        this.sprites = pXSpeed;
        this.xd = p_106580_ + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.yd = pZ + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.zd = p_106582_ + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.rCol = f = this.random.nextFloat() * 0.3f + 0.7f;
        this.gCol = f;
        this.bCol = f;
        this.quadSize = 0.1f * (this.random.nextFloat() * this.random.nextFloat() * 6.0f + 1.0f);
        this.lifetime = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
        this.setSpriteFromAge(pXSpeed);
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106602_, double pY, double p_106604_, double pZ, double p_106606_) {
            return new ExplodeParticle(pLevel, pX, p_106602_, pY, p_106604_, pZ, p_106606_, this.sprites);
        }
    }
}

