/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class FallingDustParticle
extends TextureSheetParticle {
    private final float rotSpeed;
    private final SpriteSet sprites;

    FallingDustParticle(ClientLevel pLevel, double pX, double p_106612_, double pY, float p_106614_, float pZ, float p_106616_, SpriteSet pXSpeed) {
        super(pLevel, pX, p_106612_, pY);
        this.sprites = pXSpeed;
        this.rCol = p_106614_;
        this.gCol = pZ;
        this.bCol = p_106616_;
        float f = 0.9f;
        this.quadSize *= 0.67499995f;
        int i = (int)(32.0 / (Math.random() * 0.8 + 0.2));
        this.lifetime = (int)Math.max((float)i * 0.9f, 1.0f);
        this.setSpriteFromAge(pXSpeed);
        this.rotSpeed = ((float)Math.random() - 0.5f) * 0.1f;
        this.roll = (float)Math.random() * ((float)Math.PI * 2);
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public float getQuadSize(float pScaleFactor) {
        return this.quadSize * Mth.clamp(((float)this.age + pScaleFactor) / (float)this.lifetime * 32.0f, 0.0f, 1.0f);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
            this.oRoll = this.roll;
            this.roll += (float)Math.PI * this.rotSpeed * 2.0f;
            if (this.onGround) {
                this.roll = 0.0f;
                this.oRoll = 0.0f;
            }
            this.move(this.xd, this.yd, this.zd);
            this.yd -= (double)0.003f;
            this.yd = Math.max(this.yd, (double)-0.14f);
        }
    }

    public static class Provider
    implements ParticleProvider<BlockParticleOption> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        @Nullable
        public Particle createParticle(BlockParticleOption pType, ClientLevel pLevel, double pX, double p_106639_, double pY, double p_106641_, double pZ, double p_106643_) {
            BlockState blockstate = pType.getState();
            if (!blockstate.isAir() && blockstate.getRenderShape() == RenderShape.INVISIBLE) {
                return null;
            }
            BlockPos blockpos = new BlockPos(pX, p_106639_, pY);
            int i = Minecraft.getInstance().getBlockColors().getColor(blockstate, pLevel, blockpos);
            if (blockstate.getBlock() instanceof FallingBlock) {
                i = ((FallingBlock)blockstate.getBlock()).getDustColor(blockstate, pLevel, blockpos);
            }
            float f = (float)(i >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            return new FallingDustParticle(pLevel, pX, p_106639_, pY, f, f1, f2, this.sprite);
        }
    }
}

