/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class GlowParticle
extends TextureSheetParticle {
    static final Random RANDOM = new Random();
    private final SpriteSet sprites;

    GlowParticle(ClientLevel pLevel, double pX, double p_172138_, double pY, double p_172140_, double pZ, double p_172142_, SpriteSet pXSpeed) {
        super(pLevel, pX, p_172138_, pY, p_172140_, pZ, p_172142_);
        this.friction = 0.96f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = pXSpeed;
        this.quadSize *= 0.75f;
        this.hasPhysics = false;
        this.setSpriteFromAge(pXSpeed);
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public int getLightColor(float pPartialTick) {
        float f = ((float)this.age + pPartialTick) / (float)this.lifetime;
        f = Mth.clamp(f, 0.0f, 1.0f);
        int i = super.getLightColor(pPartialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    @Override
    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    public static class ElectricSparkProvider
    implements ParticleProvider<SimpleParticleType> {
        private final double SPEED_FACTOR = 0.25;
        private final SpriteSet sprite;

        public ElectricSparkProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172165_, double pY, double p_172167_, double pZ, double p_172169_) {
            GlowParticle glowparticle = new GlowParticle(pLevel, pX, p_172165_, pY, 0.0, 0.0, 0.0, this.sprite);
            glowparticle.setColor(1.0f, 0.9f, 1.0f);
            glowparticle.setParticleSpeed(p_172167_ * 0.25, pZ * 0.25, p_172169_ * 0.25);
            int i = 2;
            int j = 4;
            glowparticle.setLifetime(pLevel.random.nextInt(2) + 2);
            return glowparticle;
        }
    }

    public static class GlowSquidProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public GlowSquidProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172186_, double pY, double p_172188_, double pZ, double p_172190_) {
            GlowParticle glowparticle = new GlowParticle(pLevel, pX, p_172186_, pY, 0.5 - RANDOM.nextDouble(), pZ, 0.5 - RANDOM.nextDouble(), this.sprite);
            if (pLevel.random.nextBoolean()) {
                glowparticle.setColor(0.6f, 1.0f, 0.8f);
            } else {
                glowparticle.setColor(0.08f, 0.4f, 0.4f);
            }
            glowparticle.yd *= (double)0.2f;
            if (p_172188_ == 0.0 && p_172190_ == 0.0) {
                glowparticle.xd *= (double)0.1f;
                glowparticle.zd *= (double)0.1f;
            }
            glowparticle.setLifetime((int)(8.0 / (pLevel.random.nextDouble() * 0.8 + 0.2)));
            return glowparticle;
        }
    }

    public static class ScrapeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final double SPEED_FACTOR = 0.01;
        private final SpriteSet sprite;

        public ScrapeProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172208_, double pY, double p_172210_, double pZ, double p_172212_) {
            GlowParticle glowparticle = new GlowParticle(pLevel, pX, p_172208_, pY, 0.0, 0.0, 0.0, this.sprite);
            if (pLevel.random.nextBoolean()) {
                glowparticle.setColor(0.29f, 0.58f, 0.51f);
            } else {
                glowparticle.setColor(0.43f, 0.77f, 0.62f);
            }
            glowparticle.setParticleSpeed(p_172210_ * 0.01, pZ * 0.01, p_172212_ * 0.01);
            int i = 10;
            int j = 40;
            glowparticle.setLifetime(pLevel.random.nextInt(30) + 10);
            return glowparticle;
        }
    }

    public static class WaxOffProvider
    implements ParticleProvider<SimpleParticleType> {
        private final double SPEED_FACTOR = 0.01;
        private final SpriteSet sprite;

        public WaxOffProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172230_, double pY, double p_172232_, double pZ, double p_172234_) {
            GlowParticle glowparticle = new GlowParticle(pLevel, pX, p_172230_, pY, 0.0, 0.0, 0.0, this.sprite);
            glowparticle.setColor(1.0f, 0.9f, 1.0f);
            glowparticle.setParticleSpeed(p_172232_ * 0.01 / 2.0, pZ * 0.01, p_172234_ * 0.01 / 2.0);
            int i = 10;
            int j = 40;
            glowparticle.setLifetime(pLevel.random.nextInt(30) + 10);
            return glowparticle;
        }
    }

    public static class WaxOnProvider
    implements ParticleProvider<SimpleParticleType> {
        private final double SPEED_FACTOR = 0.01;
        private final SpriteSet sprite;

        public WaxOnProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172252_, double pY, double p_172254_, double pZ, double p_172256_) {
            GlowParticle glowparticle = new GlowParticle(pLevel, pX, p_172252_, pY, 0.0, 0.0, 0.0, this.sprite);
            glowparticle.setColor(0.91f, 0.55f, 0.08f);
            glowparticle.setParticleSpeed(p_172254_ * 0.01 / 2.0, pZ * 0.01, p_172256_ * 0.01 / 2.0);
            int i = 10;
            int j = 40;
            glowparticle.setLifetime(pLevel.random.nextInt(30) + 10);
            return glowparticle;
        }
    }
}

