/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class HeartParticle
extends TextureSheetParticle {
    HeartParticle(ClientLevel p_106847_, double p_106848_, double p_106849_, double p_106850_) {
        super(p_106847_, p_106848_, p_106849_, p_106850_, 0.0, 0.0, 0.0);
        this.speedUpWhenYMotionIsBlocked = true;
        this.friction = 0.86f;
        this.xd *= (double)0.01f;
        this.yd *= (double)0.01f;
        this.zd *= (double)0.01f;
        this.yd += 0.1;
        this.quadSize *= 1.5f;
        this.lifetime = 16;
        this.hasPhysics = false;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public float getQuadSize(float pScaleFactor) {
        return this.quadSize * Mth.clamp(((float)this.age + pScaleFactor) / (float)this.lifetime * 32.0f, 0.0f, 1.0f);
    }

    public static class AngryVillagerProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public AngryVillagerProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106877_, double pY, double p_106879_, double pZ, double p_106881_) {
            HeartParticle heartparticle = new HeartParticle(pLevel, pX, p_106877_ + 0.5, pY);
            heartparticle.pickSprite(this.sprite);
            heartparticle.setColor(1.0f, 1.0f, 1.0f);
            return heartparticle;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106898_, double pY, double p_106900_, double pZ, double p_106902_) {
            HeartParticle heartparticle = new HeartParticle(pLevel, pX, p_106898_, pY);
            heartparticle.pickSprite(this.sprite);
            return heartparticle;
        }
    }
}

