/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class HugeExplosionParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    HugeExplosionParticle(ClientLevel pLevel, double pX, double p_106907_, double pY, double p_106909_, SpriteSet pZ) {
        super(pLevel, pX, p_106907_, pY, 0.0, 0.0, 0.0);
        float f;
        this.lifetime = 6 + this.random.nextInt(4);
        this.rCol = f = this.random.nextFloat() * 0.6f + 0.4f;
        this.gCol = f;
        this.bCol = f;
        this.quadSize = 2.0f * (1.0f - (float)p_106909_ * 0.5f);
        this.sprites = pZ;
        this.setSpriteFromAge(pZ);
    }

    @Override
    public int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.sprites);
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet p_106925_) {
            this.sprites = p_106925_;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_106939_, double pY, double p_106941_, double pZ, double p_106943_) {
            return new HugeExplosionParticle(pLevel, pX, p_106939_, pY, p_106941_, this.sprites);
        }
    }
}

