/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class PlayerCloudParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    PlayerCloudParticle(ClientLevel pLevel, double pX, double p_107485_, double pY, double p_107487_, double pZ, double p_107489_, SpriteSet pXSpeed) {
        super(pLevel, pX, p_107485_, pY, 0.0, 0.0, 0.0);
        float f1;
        this.friction = 0.96f;
        this.sprites = pXSpeed;
        float f = 2.5f;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        this.xd += p_107487_;
        this.yd += pZ;
        this.zd += p_107489_;
        this.rCol = f1 = 1.0f - (float)(Math.random() * (double)0.3f);
        this.gCol = f1;
        this.bCol = f1;
        this.quadSize *= 1.875f;
        int i = (int)(8.0 / (Math.random() * 0.8 + 0.3));
        this.lifetime = (int)Math.max((float)i * 2.5f, 1.0f);
        this.hasPhysics = false;
        this.setSpriteFromAge(pXSpeed);
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public float getQuadSize(float pScaleFactor) {
        return this.quadSize * Mth.clamp(((float)this.age + pScaleFactor) / (float)this.lifetime * 32.0f, 0.0f, 1.0f);
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.removed) {
            double d0;
            this.setSpriteFromAge(this.sprites);
            Player player = this.level.getNearestPlayer(this.x, this.y, this.z, 2.0, false);
            if (player != null && this.y > (d0 = player.getY())) {
                this.y += (d0 - this.y) * 0.2;
                this.yd += (player.getDeltaMovement().y - this.yd) * 0.2;
                this.setPos(this.x, this.y, this.z);
            }
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_107521_, double pY, double p_107523_, double pZ, double p_107525_) {
            return new PlayerCloudParticle(pLevel, pX, p_107521_, pY, p_107523_, pZ, p_107525_, this.sprites);
        }
    }

    public static class SneezeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public SneezeProvider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_107542_, double pY, double p_107544_, double pZ, double p_107546_) {
            PlayerCloudParticle particle = new PlayerCloudParticle(pLevel, pX, p_107542_, pY, p_107544_, pZ, p_107546_, this.sprites);
            particle.setColor(200.0f, 50.0f, 120.0f);
            particle.setAlpha(0.4f);
            return particle;
        }
    }
}

