/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class SimpleAnimatedParticle
extends TextureSheetParticle {
    protected final SpriteSet sprites;
    private float fadeR;
    private float fadeG;
    private float fadeB;
    private boolean hasFade;

    protected SimpleAnimatedParticle(ClientLevel pLevel, double pX, double p_107649_, double pY, SpriteSet p_107651_, float pZ) {
        super(pLevel, pX, p_107649_, pY);
        this.friction = 0.91f;
        this.gravity = pZ;
        this.sprites = p_107651_;
    }

    public void setColor(int pColor) {
        float f = (float)((pColor & 0xFF0000) >> 16) / 255.0f;
        float f1 = (float)((pColor & 0xFF00) >> 8) / 255.0f;
        float f2 = (float)((pColor & 0xFF) >> 0) / 255.0f;
        float f3 = 1.0f;
        this.setColor(f * 1.0f, f1 * 1.0f, f2 * 1.0f);
    }

    public void setFadeColor(int pRgb) {
        this.fadeR = (float)((pRgb & 0xFF0000) >> 16) / 255.0f;
        this.fadeG = (float)((pRgb & 0xFF00) >> 8) / 255.0f;
        this.fadeB = (float)((pRgb & 0xFF) >> 0) / 255.0f;
        this.hasFade = true;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        if (this.age > this.lifetime / 2) {
            this.setAlpha(1.0f - ((float)this.age - (float)(this.lifetime / 2)) / (float)this.lifetime);
            if (this.hasFade) {
                this.rCol += (this.fadeR - this.rCol) * 0.2f;
                this.gCol += (this.fadeG - this.gCol) * 0.2f;
                this.bCol += (this.fadeB - this.bCol) * 0.2f;
            }
        }
    }

    @Override
    public int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }
}

