/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class SnowflakeParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected SnowflakeParticle(ClientLevel pLevel, double pX, double p_172294_, double pY, double p_172296_, double pZ, double p_172298_, SpriteSet pXSpeed) {
        super(pLevel, pX, p_172294_, pY);
        this.gravity = 0.225f;
        this.friction = 1.0f;
        this.sprites = pXSpeed;
        this.xd = p_172296_ + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.yd = pZ + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.zd = p_172298_ + (Math.random() * 2.0 - 1.0) * (double)0.05f;
        this.quadSize = 0.1f * (this.random.nextFloat() * this.random.nextFloat() * 1.0f + 1.0f);
        this.lifetime = (int)(16.0 / ((double)this.random.nextFloat() * 0.8 + 0.2)) + 2;
        this.setSpriteFromAge(pXSpeed);
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.xd *= (double)0.95f;
        this.yd *= (double)0.9f;
        this.zd *= (double)0.95f;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172318_, double pY, double p_172320_, double pZ, double p_172322_) {
            SnowflakeParticle snowflakeparticle = new SnowflakeParticle(pLevel, pX, p_172318_, pY, p_172320_, pZ, p_172322_, this.sprites);
            snowflakeparticle.setColor(0.923f, 0.964f, 0.999f);
            return snowflakeparticle;
        }
    }
}

