/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class SpellParticle
extends TextureSheetParticle {
    private static final Random RANDOM = new Random();
    private final SpriteSet sprites;

    SpellParticle(ClientLevel pLevel, double pX, double p_107764_, double pY, double p_107766_, double pZ, double p_107768_, SpriteSet pXSpeed) {
        super(pLevel, pX, p_107764_, pY, 0.5 - RANDOM.nextDouble(), pZ, 0.5 - RANDOM.nextDouble());
        this.friction = 0.96f;
        this.gravity = -0.1f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = pXSpeed;
        this.yd *= (double)0.2f;
        if (p_107766_ == 0.0 && p_107768_ == 0.0) {
            this.xd *= (double)0.1f;
            this.zd *= (double)0.1f;
        }
        this.quadSize *= 0.75f;
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.setSpriteFromAge(pXSpeed);
        if (this.isCloseToScopingPlayer()) {
            this.setAlpha(0.0f);
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        if (this.isCloseToScopingPlayer()) {
            this.setAlpha(0.0f);
        } else {
            this.setAlpha(Mth.lerp(0.05f, this.alpha, 1.0f));
        }
    }

    private boolean isCloseToScopingPlayer() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localplayer = minecraft.player;
        return localplayer != null && localplayer.getEyePosition().distanceToSqr(this.x, this.y, this.z) <= 9.0 && minecraft.options.getCameraType().isFirstPerson() && localplayer.isScoping();
    }

    public static class AmbientMobProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public AmbientMobProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_107798_, double pY, double p_107800_, double pZ, double p_107802_) {
            SpellParticle particle = new SpellParticle(pLevel, pX, p_107798_, pY, p_107800_, pZ, p_107802_, this.sprite);
            particle.setAlpha(0.15f);
            particle.setColor((float)p_107800_, (float)pZ, (float)p_107802_);
            return particle;
        }
    }

    public static class InstantProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public InstantProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_107819_, double pY, double p_107821_, double pZ, double p_107823_) {
            return new SpellParticle(pLevel, pX, p_107819_, pY, p_107821_, pZ, p_107823_, this.sprite);
        }
    }

    public static class MobProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public MobProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_107840_, double pY, double p_107842_, double pZ, double p_107844_) {
            SpellParticle particle = new SpellParticle(pLevel, pX, p_107840_, pY, p_107842_, pZ, p_107844_, this.sprite);
            particle.setColor((float)p_107842_, (float)pZ, (float)p_107844_);
            return particle;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_107861_, double pY, double p_107863_, double pZ, double p_107865_) {
            return new SpellParticle(pLevel, pX, p_107861_, pY, p_107863_, pZ, p_107865_, this.sprite);
        }
    }

    public static class WitchProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public WitchProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_107882_, double pY, double p_107884_, double pZ, double p_107886_) {
            SpellParticle spellparticle = new SpellParticle(pLevel, pX, p_107882_, pY, p_107884_, pZ, p_107886_, this.sprite);
            float f = pLevel.random.nextFloat() * 0.5f + 0.35f;
            spellparticle.setColor(1.0f * f, 0.0f * f, 1.0f * f);
            return spellparticle;
        }
    }
}

