/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import java.util.Optional;
import java.util.Random;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class SuspendedParticle
extends TextureSheetParticle {
    SuspendedParticle(ClientLevel pLevel, SpriteSet pSprites, double pX, double p_172406_, double pY) {
        super(pLevel, pX, p_172406_ - 0.125, pY);
        this.setSize(0.01f, 0.01f);
        this.pickSprite(pSprites);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.friction = 1.0f;
        this.gravity = 0.0f;
    }

    SuspendedParticle(ClientLevel pLevel, SpriteSet pSprites, double pX, double p_172412_, double pY, double p_172414_, double pZ, double p_172416_) {
        super(pLevel, pX, p_172412_ - 0.125, pY, p_172414_, pZ, p_172416_);
        this.setSize(0.01f, 0.01f);
        this.pickSprite(pSprites);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.6f;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.hasPhysics = false;
        this.friction = 1.0f;
        this.gravity = 0.0f;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public static class CrimsonSporeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public CrimsonSporeProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_108056_, double pY, double p_108058_, double pZ, double p_108060_) {
            Random random = pLevel.random;
            double d0 = random.nextGaussian() * (double)1.0E-6f;
            double d1 = random.nextGaussian() * (double)1.0E-4f;
            double d2 = random.nextGaussian() * (double)1.0E-6f;
            SuspendedParticle suspendedparticle = new SuspendedParticle(pLevel, this.sprite, pX, p_108056_, pY, d0, d1, d2);
            suspendedparticle.setColor(0.9f, 0.4f, 0.5f);
            return suspendedparticle;
        }
    }

    public static class SporeBlossomAirProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public SporeBlossomAirProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_172433_, double pY, double p_172435_, double pZ, double p_172437_) {
            SuspendedParticle suspendedparticle = new SuspendedParticle(pLevel, this.sprite, pX, p_172433_, pY, 0.0, -0.8f, 0.0){

                @Override
                public Optional<ParticleGroup> getParticleGroup() {
                    return Optional.of(ParticleGroup.SPORE_BLOSSOM);
                }
            };
            suspendedparticle.lifetime = Mth.randomBetweenInclusive(pLevel.random, 500, 1000);
            suspendedparticle.gravity = 0.01f;
            suspendedparticle.setColor(0.32f, 0.5f, 0.22f);
            return suspendedparticle;
        }
    }

    public static class UnderwaterProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public UnderwaterProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_108077_, double pY, double p_108079_, double pZ, double p_108081_) {
            SuspendedParticle suspendedparticle = new SuspendedParticle(pLevel, this.sprite, pX, p_108077_, pY);
            suspendedparticle.setColor(0.4f, 0.4f, 0.7f);
            return suspendedparticle;
        }
    }

    public static class WarpedSporeProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public WarpedSporeProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_108098_, double pY, double p_108100_, double pZ, double p_108102_) {
            double d0 = (double)pLevel.random.nextFloat() * -1.9 * (double)pLevel.random.nextFloat() * 0.1;
            SuspendedParticle suspendedparticle = new SuspendedParticle(pLevel, this.sprite, pX, p_108098_, pY, 0.0, d0, 0.0);
            suspendedparticle.setColor(0.1f, 0.1f, 0.3f);
            suspendedparticle.setSize(0.001f, 0.001f);
            return suspendedparticle;
        }
    }
}

