/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class SuspendedTownParticle
extends TextureSheetParticle {
    SuspendedTownParticle(ClientLevel p_108104_, double p_108105_, double p_108106_, double p_108107_, double p_108108_, double p_108109_, double p_108110_) {
        super(p_108104_, p_108105_, p_108106_, p_108107_, p_108108_, p_108109_, p_108110_);
        float f;
        this.rCol = f = this.random.nextFloat() * 0.1f + 0.2f;
        this.gCol = f;
        this.bCol = f;
        this.setSize(0.02f, 0.02f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.5f;
        this.xd *= (double)0.02f;
        this.yd *= (double)0.02f;
        this.zd *= (double)0.02f;
        this.lifetime = (int)(20.0 / (Math.random() * 0.8 + 0.2));
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public void move(double pX, double p_108123_, double pY) {
        this.setBoundingBox(this.getBoundingBox().move(pX, p_108123_, pY));
        this.setLocationFromBoundingbox();
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.lifetime-- <= 0) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            this.xd *= 0.99;
            this.yd *= 0.99;
            this.zd *= 0.99;
        }
    }

    public static class ComposterFillProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public ComposterFillProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_108142_, double pY, double p_108144_, double pZ, double p_108146_) {
            SuspendedTownParticle suspendedtownparticle = new SuspendedTownParticle(pLevel, pX, p_108142_, pY, p_108144_, pZ, p_108146_);
            suspendedtownparticle.pickSprite(this.sprite);
            suspendedtownparticle.setColor(1.0f, 1.0f, 1.0f);
            suspendedtownparticle.setLifetime(3 + pLevel.getRandom().nextInt(5));
            return suspendedtownparticle;
        }
    }

    public static class DolphinSpeedProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public DolphinSpeedProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_108163_, double pY, double p_108165_, double pZ, double p_108167_) {
            SuspendedTownParticle suspendedtownparticle = new SuspendedTownParticle(pLevel, pX, p_108163_, pY, p_108165_, pZ, p_108167_);
            suspendedtownparticle.setColor(0.3f, 0.5f, 1.0f);
            suspendedtownparticle.pickSprite(this.sprite);
            suspendedtownparticle.setAlpha(1.0f - pLevel.random.nextFloat() * 0.7f);
            suspendedtownparticle.setLifetime(suspendedtownparticle.getLifetime() / 2);
            return suspendedtownparticle;
        }
    }

    public static class HappyVillagerProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public HappyVillagerProvider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_108184_, double pY, double p_108186_, double pZ, double p_108188_) {
            SuspendedTownParticle suspendedtownparticle = new SuspendedTownParticle(pLevel, pX, p_108184_, pY, p_108186_, pZ, p_108188_);
            suspendedtownparticle.pickSprite(this.sprite);
            suspendedtownparticle.setColor(1.0f, 1.0f, 1.0f);
            return suspendedtownparticle;
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_108205_, double pY, double p_108207_, double pZ, double p_108209_) {
            SuspendedTownParticle suspendedtownparticle = new SuspendedTownParticle(pLevel, pX, p_108205_, pY, p_108207_, pZ, p_108209_);
            suspendedtownparticle.pickSprite(this.sprite);
            return suspendedtownparticle;
        }
    }
}

