/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class TrackingEmitter
extends NoRenderParticle {
    private final Entity entity;
    private int life;
    private final int lifeTime;
    private final ParticleOptions particleType;

    public TrackingEmitter(ClientLevel pLevel, Entity pEntity, ParticleOptions pParticleType) {
        this(pLevel, pEntity, pParticleType, 3);
    }

    public TrackingEmitter(ClientLevel pLevel, Entity pEntity, ParticleOptions pParticleType, int pLifetime) {
        this(pLevel, pEntity, pParticleType, pLifetime, pEntity.getDeltaMovement());
    }

    private TrackingEmitter(ClientLevel pLevel, Entity pEntity, ParticleOptions pParticleType, int pLifetime, Vec3 pSpeedVector) {
        super(pLevel, pEntity.getX(), pEntity.getY(0.5), pEntity.getZ(), pSpeedVector.x, pSpeedVector.y, pSpeedVector.z);
        this.entity = pEntity;
        this.lifeTime = pLifetime;
        this.particleType = pParticleType;
        this.tick();
    }

    @Override
    public void tick() {
        int i = 0;
        while (i < 16) {
            double d2;
            double d1;
            double d0 = this.random.nextFloat() * 2.0f - 1.0f;
            if (!(d0 * d0 + (d1 = (double)(this.random.nextFloat() * 2.0f - 1.0f)) * d1 + (d2 = (double)(this.random.nextFloat() * 2.0f - 1.0f)) * d2 > 1.0)) {
                double d3 = this.entity.getX(d0 / 4.0);
                double d4 = this.entity.getY(0.5 + d1 / 4.0);
                double d5 = this.entity.getZ(d2 / 4.0);
                this.level.addParticle(this.particleType, false, d3, d4, d5, d0, d1 + 0.2, d2);
            }
            ++i;
        }
        ++this.life;
        if (this.life >= this.lifeTime) {
            this.remove();
        }
    }
}

