/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.util.Mth;
import net.minecraft.world.level.gameevent.vibrations.VibrationPath;
import net.minecraft.world.phys.Vec3;

public class VibrationSignalParticle
extends TextureSheetParticle {
    private final VibrationPath vibrationPath;
    private float yRot;
    private float yRotO;

    VibrationSignalParticle(ClientLevel pLevel, VibrationPath pVibrationPath, int pLifetime) {
        super(pLevel, (float)pVibrationPath.getOrigin().getX() + 0.5f, (float)pVibrationPath.getOrigin().getY() + 0.5f, (float)pVibrationPath.getOrigin().getZ() + 0.5f, 0.0, 0.0, 0.0);
        this.quadSize = 0.3f;
        this.vibrationPath = pVibrationPath;
        this.lifetime = pLifetime;
    }

    @Override
    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        float f = Mth.sin(((float)this.age + pPartialTicks - (float)Math.PI * 2) * 0.05f) * 2.0f;
        float f1 = Mth.lerp(pPartialTicks, this.yRotO, this.yRot);
        float f2 = 1.0472f;
        this.renderSignal(pBuffer, pRenderInfo, pPartialTicks, p_172487_ -> {
            p_172487_.mul(Vector3f.YP.rotation(f1));
            p_172487_.mul(Vector3f.XP.rotation(-1.0472f));
            p_172487_.mul(Vector3f.YP.rotation(f));
        });
        this.renderSignal(pBuffer, pRenderInfo, pPartialTicks, p_172473_ -> {
            p_172473_.mul(Vector3f.YP.rotation((float)(-Math.PI) + f1));
            p_172473_.mul(Vector3f.XP.rotation(1.0472f));
            p_172473_.mul(Vector3f.YP.rotation(f));
        });
    }

    private void renderSignal(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks, Consumer<Quaternion> pQuaternionConsumer) {
        Vec3 vec3 = pRenderInfo.getPosition();
        float f = (float)(Mth.lerp((double)pPartialTicks, this.xo, this.x) - vec3.x());
        float f1 = (float)(Mth.lerp((double)pPartialTicks, this.yo, this.y) - vec3.y());
        float f2 = (float)(Mth.lerp((double)pPartialTicks, this.zo, this.z) - vec3.z());
        Vector3f vector3f = new Vector3f(0.5f, 0.5f, 0.5f);
        vector3f.normalize();
        Quaternion quaternion = new Quaternion(vector3f, 0.0f, true);
        pQuaternionConsumer.accept(quaternion);
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.transform(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.getQuadSize(pPartialTicks);
        int i = 0;
        while (i < 4) {
            Vector3f vector3f2 = avector3f[i];
            vector3f2.transform(quaternion);
            vector3f2.mul(f3);
            vector3f2.add(f, f1, f2);
            ++i;
        }
        float f6 = this.getU0();
        float f7 = this.getU1();
        float f4 = this.getV0();
        float f5 = this.getV1();
        int j = this.getLightColor(pPartialTicks);
        pBuffer.vertex(avector3f[0].x(), avector3f[0].y(), avector3f[0].z()).uv(f7, f5).color(this.rCol, this.gCol, this.bCol, this.alpha).uv2(j).endVertex();
        pBuffer.vertex(avector3f[1].x(), avector3f[1].y(), avector3f[1].z()).uv(f7, f4).color(this.rCol, this.gCol, this.bCol, this.alpha).uv2(j).endVertex();
        pBuffer.vertex(avector3f[2].x(), avector3f[2].y(), avector3f[2].z()).uv(f6, f4).color(this.rCol, this.gCol, this.bCol, this.alpha).uv2(j).endVertex();
        pBuffer.vertex(avector3f[3].x(), avector3f[3].y(), avector3f[3].z()).uv(f6, f5).color(this.rCol, this.gCol, this.bCol, this.alpha).uv2(j).endVertex();
    }

    @Override
    public int getLightColor(float pPartialTick) {
        return 240;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public void tick() {
        super.tick();
        Optional<BlockPos> optional = this.vibrationPath.getDestination().getPosition(this.level);
        if (!optional.isPresent()) {
            this.remove();
        } else {
            double d0 = (double)this.age / (double)this.lifetime;
            BlockPos blockpos = this.vibrationPath.getOrigin();
            BlockPos blockpos1 = optional.get();
            this.x = Mth.lerp(d0, (double)blockpos.getX() + 0.5, (double)blockpos1.getX() + 0.5);
            this.y = Mth.lerp(d0, (double)blockpos.getY() + 0.5, (double)blockpos1.getY() + 0.5);
            this.z = Mth.lerp(d0, (double)blockpos.getZ() + 0.5, (double)blockpos1.getZ() + 0.5);
            this.yRotO = this.yRot;
            this.yRot = (float)Mth.atan2(this.x - (double)blockpos1.getX(), this.z - (double)blockpos1.getZ());
        }
    }

    public static class Provider
    implements ParticleProvider<VibrationParticleOption> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        @Override
        public Particle createParticle(VibrationParticleOption pType, ClientLevel pLevel, double pX, double p_172504_, double pY, double p_172506_, double pZ, double p_172508_) {
            VibrationSignalParticle vibrationsignalparticle = new VibrationSignalParticle(pLevel, pType.getVibrationPath(), pType.getVibrationPath().getArrivalInTicks());
            vibrationsignalparticle.pickSprite(this.sprite);
            vibrationsignalparticle.setAlpha(1.0f);
            return vibrationsignalparticle;
        }
    }
}

