/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class WakeParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    WakeParticle(ClientLevel pLevel, double pX, double p_108409_, double pY, double p_108411_, double pZ, double p_108413_, SpriteSet pXSpeed) {
        super(pLevel, pX, p_108409_, pY, 0.0, 0.0, 0.0);
        this.sprites = pXSpeed;
        this.xd *= (double)0.3f;
        this.yd = Math.random() * (double)0.2f + (double)0.1f;
        this.zd *= (double)0.3f;
        this.setSize(0.01f, 0.01f);
        this.lifetime = (int)(8.0 / (Math.random() * 0.8 + 0.2));
        this.setSpriteFromAge(pXSpeed);
        this.gravity = 0.0f;
        this.xd = p_108411_;
        this.yd = pZ;
        this.zd = p_108413_;
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        int i = 60 - this.lifetime;
        if (this.lifetime-- <= 0) {
            this.remove();
        } else {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.98f;
            this.yd *= (double)0.98f;
            this.zd *= (double)0.98f;
            float f = (float)i * 0.001f;
            this.setSize(f, f);
            this.setSprite(this.sprites.get(i % 4, 4));
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet pSprites) {
            this.sprites = pSprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double p_108443_, double pY, double p_108445_, double pZ, double p_108447_) {
            return new WakeParticle(pLevel, pX, p_108443_, pY, p_108445_, pZ, p_108447_, this.sprites);
        }
    }
}

