/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import com.google.common.hash.Hashing;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.optifine.Config;
import net.optifine.player.CapeUtils;
import net.optifine.player.PlayerConfigurations;
import net.optifine.reflect.Reflector;

public abstract class AbstractClientPlayer
extends Player {
    private String cachedSkinId = null;
    private boolean hasFetchedSkin = false;
    private ResourceLocation cachedSkinLocation = null;
    private String cachedCapeId = null;
    private boolean hasFetchedCape = false;
    private static final String SKIN_URL_TEMPLATE = "http://skins.minecraft.net/MinecraftSkins/%s.png";
    public static final int SKIN_HEAD_U = 8;
    public static final int SKIN_HEAD_V = 8;
    public static final int SKIN_HEAD_WIDTH = 8;
    public static final int SKIN_HEAD_HEIGHT = 8;
    public static final int SKIN_HAT_U = 40;
    public static final int SKIN_HAT_V = 8;
    public static final int SKIN_HAT_WIDTH = 8;
    public static final int SKIN_HAT_HEIGHT = 8;
    public static final int SKIN_TEX_WIDTH = 64;
    public static final int SKIN_TEX_HEIGHT = 64;
    @Nullable
    private PlayerInfo playerInfo;
    public float elytraRotX;
    public float elytraRotY;
    public float elytraRotZ;
    public final ClientLevel clientLevel;
    private ResourceLocation locationOfCape = null;
    private long reloadCapeTimeMs = 0L;
    private boolean elytraOfCape = false;
    private String nameClear = null;
    public ShoulderRidingEntity entityShoulderLeft;
    public ShoulderRidingEntity entityShoulderRight;
    public float capeRotateX;
    public float capeRotateY;
    public float capeRotateZ;
    private static final ResourceLocation TEXTURE_ELYTRA = new ResourceLocation("textures/entity/elytra.png");

    public AbstractClientPlayer(ClientLevel pClientLevel, GameProfile pGameProfile) {
        super(pClientLevel, pClientLevel.getSharedSpawnPos(), pClientLevel.getSharedSpawnAngle(), pGameProfile);
        this.clientLevel = pClientLevel;
        this.nameClear = pGameProfile.getName();
        if (this.nameClear != null && !this.nameClear.isEmpty()) {
            this.nameClear = StringUtil.stripColor(this.nameClear);
        }
        CapeUtils.downloadCape(this);
        PlayerConfigurations.getPlayerConfiguration(this);
    }

    @Override
    public boolean isSpectator() {
        PlayerInfo playerinfo = Minecraft.getInstance().getConnection().getPlayerInfo(this.getGameProfile().getId());
        return playerinfo != null && playerinfo.getGameMode() == GameType.SPECTATOR;
    }

    @Override
    public boolean isCreative() {
        PlayerInfo playerinfo = Minecraft.getInstance().getConnection().getPlayerInfo(this.getGameProfile().getId());
        return playerinfo != null && playerinfo.getGameMode() == GameType.CREATIVE;
    }

    public boolean isCapeLoaded() {
        return this.getPlayerInfo() != null;
    }

    @Nullable
    protected PlayerInfo getPlayerInfo() {
        if (this.playerInfo == null) {
            this.playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(this.getUUID());
        }
        return this.playerInfo;
    }

    public boolean isSkinLoaded() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo != null && playerinfo.isSkinLoaded();
    }

    private boolean isOfflineMode() {
        return Minecraft.getInstance().getConnection() == null || !Minecraft.getInstance().getConnection().getConnection().isConnected();
    }

    public ResourceLocation getSkinTextureLocation() {
        boolean offlineMode;
        boolean bl = offlineMode = Minecraft.getInstance().getConnection() == null || Minecraft.getInstance().getConnection().getConnection() == null || !Minecraft.getInstance().getConnection().getConnection().isConnected();
        if (offlineMode) {
            PlayerInfo playerinfo = this.getPlayerInfo();
            return playerinfo == null ? DefaultPlayerSkin.getDefaultSkin(this.getUUID()) : playerinfo.getSkinLocation();
        }
        if (!this.hasFetchedSkin) {
            this.fetchAndCacheSkinData();
        }
        if (this.cachedSkinLocation != null && this.textureExists(this.cachedSkinLocation)) {
            return this.cachedSkinLocation;
        }
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? DefaultPlayerSkin.getDefaultSkin(this.getUUID()) : playerinfo.getSkinLocation();
    }

    private void fetchAndCacheSkinData() {
        String username = this.getGameProfile().getName();
        try {
            try {
                String apiResponse = AbstractClientPlayer.getSkinIdWithTimeout(username, 5000);
                JsonObject jsonResponse = JsonParser.parseString((String)apiResponse).getAsJsonObject();
                if (jsonResponse.has("skinId")) {
                    this.cachedSkinId = jsonResponse.get("skinId").getAsString();
                    this.cachedSkinLocation = new ResourceLocation("textures/diamondclient/skins/skin" + this.cachedSkinId + ".png");
                }
            }
            catch (IOException | RuntimeException e) {
                System.err.println("Error getting skin ID, falling back to default: " + e.getMessage());
                this.cachedSkinId = "default";
                this.cachedSkinLocation = null;
                this.hasFetchedSkin = true;
            }
        }
        finally {
            this.hasFetchedSkin = true;
        }
    }

    private static String getSkinIdWithTimeout(String username, int timeoutMs) throws IOException {
        URL url = new URL("http://213.181.206.140:23070/diamondclient/api/skin/" + username);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(timeoutMs);
        connection.setReadTimeout(timeoutMs);
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String string;
                block15: {
                    Throwable throwable = null;
                    Object var6_7 = null;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    try {
                        String inputLine;
                        StringBuilder response = new StringBuilder();
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                        }
                        string = response.toString();
                        if (in == null) break block15;
                    }
                    catch (Throwable throwable2) {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    in.close();
                }
                return string;
            }
            throw new IOException("Server returned HTTP response code: " + responseCode);
        }
        finally {
            connection.disconnect();
        }
    }

    private boolean textureExists(ResourceLocation location) {
        try {
            Minecraft.getInstance().getResourceManager().getResource(location);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getCapeId(String username) throws IOException {
        String apiUrl = "http://213.181.206.140:23070/diamondclient/api/cape/" + username;
        URL url = new URL(apiUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(3000);
        connection.setReadTimeout(3000);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        if (responseCode == 404) {
            throw new IOException("User not found: " + username);
        }
        throw new IOException("API request failed with response code: " + responseCode);
    }

    @Nullable
    public ResourceLocation getCloakTextureLocation() {
        String username;
        if (this.isOfflineMode()) {
            return this.handleOfflineCape();
        }
        String string = username = Minecraft.getInstance().player != null ? Minecraft.getInstance().player.getDisplayName().getString() : Minecraft.getInstance().getUser().getName();
        if (!this.hasFetchedCape) {
            try {
                String apiResponse = AbstractClientPlayer.getCapeId(username);
                JsonObject jsonResponse = JsonParser.parseString((String)apiResponse).getAsJsonObject();
                if (jsonResponse.has("capeId")) {
                    this.cachedCapeId = jsonResponse.get("capeId").getAsString();
                    System.out.println("Cape ID found for " + username + ": " + this.cachedCapeId);
                } else {
                    this.cachedCapeId = null;
                }
            }
            catch (JsonParseException | IOException e) {
                System.err.println("Error getting cape ID: " + e.getMessage());
                this.cachedCapeId = null;
            }
            this.hasFetchedCape = true;
        }
        if (this.cachedCapeId != null && this.getGameProfile().getName().equals(username)) {
            return new ResourceLocation("textures/diamondclient/capes/cape" + this.cachedCapeId + ".png");
        }
        if (!Config.isShowCapes()) {
            return null;
        }
        if (this.reloadCapeTimeMs != 0L && System.currentTimeMillis() > this.reloadCapeTimeMs) {
            CapeUtils.reloadCape(this);
            this.reloadCapeTimeMs = 0L;
            PlayerConfigurations.setPlayerConfiguration(this.getNameClear(), null);
        }
        if (this.locationOfCape != null) {
            return this.locationOfCape;
        }
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? null : playerinfo.getCapeLocation();
    }

    @Nullable
    private ResourceLocation handleOfflineCape() {
        if (!Config.isShowCapes()) {
            return null;
        }
        if (this.locationOfCape != null && this.textureExists(this.locationOfCape)) {
            return this.locationOfCape;
        }
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? null : playerinfo.getCapeLocation();
    }

    public boolean isElytraLoaded() {
        return this.getPlayerInfo() != null;
    }

    @Nullable
    public ResourceLocation getElytraTextureLocation() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? null : playerinfo.getElytraLocation();
    }

    public static void registerSkinTexture(ResourceLocation pTextureLocation, String pName) {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstracttexture = texturemanager.getTexture(pTextureLocation, MissingTextureAtlasSprite.getTexture());
        if (abstracttexture == MissingTextureAtlasSprite.getTexture()) {
            HttpTexture abstracttexture1 = new HttpTexture(null, String.format(SKIN_URL_TEMPLATE, StringUtil.stripColor(pName)), DefaultPlayerSkin.getDefaultSkin(AbstractClientPlayer.createPlayerUUID(pName)), true, null);
            texturemanager.register(pTextureLocation, abstracttexture1);
        }
    }

    public static ResourceLocation getSkinLocation(String pUsername) {
        return new ResourceLocation("skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)StringUtil.stripColor(pUsername)));
    }

    public String getModelName() {
        PlayerInfo playerinfo = this.getPlayerInfo();
        return playerinfo == null ? DefaultPlayerSkin.getSkinModelName(this.getUUID()) : playerinfo.getModelName();
    }

    public float getFieldOfViewModifier() {
        float f = 1.0f;
        if (this.getAbilities().flying) {
            f *= 1.1f;
        }
        if (this.getAbilities().getWalkingSpeed() == 0.0f || Float.isNaN(f *= ((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) / this.getAbilities().getWalkingSpeed() + 1.0f) / 2.0f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        ItemStack itemstack = this.getUseItem();
        if (this.isUsingItem()) {
            if (itemstack.getItem() instanceof BowItem) {
                int i = this.getTicksUsingItem();
                float f1 = (float)i / 20.0f;
                f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
                f *= 1.0f - f1 * 0.15f;
            } else if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && this.isScoping()) {
                return 0.1f;
            }
        }
        return Reflector.ForgeHooksClient_getFieldOfView2.exists() ? Reflector.callFloat(Reflector.ForgeHooksClient_getFieldOfView2, this, Float.valueOf(f)) : Mth.lerp(Minecraft.getInstance().options.fovEffectScale, 1.0f, f);
    }

    public String getNameClear() {
        return this.nameClear;
    }

    public ResourceLocation getLocationOfCape() {
        return this.locationOfCape;
    }

    public void setLocationOfCape(ResourceLocation locationOfCape) {
        this.locationOfCape = locationOfCape;
    }

    public boolean hasElytraCape() {
        ResourceLocation resourcelocation = this.getCloakTextureLocation();
        if (resourcelocation == null) {
            return false;
        }
        return resourcelocation == this.locationOfCape ? this.elytraOfCape : true;
    }

    public void setElytraOfCape(boolean elytraOfCape) {
        this.elytraOfCape = elytraOfCape;
    }

    public boolean isElytraOfCape() {
        return this.elytraOfCape;
    }

    public long getReloadCapeTimeMs() {
        return this.reloadCapeTimeMs;
    }

    public void setReloadCapeTimeMs(long reloadCapeTimeMs) {
        this.reloadCapeTimeMs = reloadCapeTimeMs;
    }
}

