/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;

public class BiomeColors {
    public static final ColorResolver GRASS_COLOR_RESOLVER = Biome::getGrassColor;
    public static final ColorResolver FOLIAGE_COLOR_RESOLVER = (p_108808_, p_108809_, p_108810_) -> p_108808_.getFoliageColor();
    public static final ColorResolver WATER_COLOR_RESOLVER = (p_108801_, p_108802_, p_108803_) -> p_108801_.getWaterColor();

    private static int getAverageColor(BlockAndTintGetter pLevel, BlockPos pBlockPos, ColorResolver pColorResolver) {
        return pLevel.getBlockTint(pBlockPos, pColorResolver);
    }

    public static int getAverageGrassColor(BlockAndTintGetter pLevel, BlockPos pBlockPos) {
        return BiomeColors.getAverageColor(pLevel, pBlockPos, GRASS_COLOR_RESOLVER);
    }

    public static int getAverageFoliageColor(BlockAndTintGetter pLevel, BlockPos pBlockPos) {
        return BiomeColors.getAverageColor(pLevel, pBlockPos, FOLIAGE_COLOR_RESOLVER);
    }

    public static int getAverageWaterColor(BlockAndTintGetter pLevel, BlockPos pBlockPos) {
        return BiomeColors.getAverageColor(pLevel, pBlockPos, WATER_COLOR_RESOLVER);
    }
}

