/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class CubeMap {
    private static final int SIDES = 6;
    private final ResourceLocation[] images = new ResourceLocation[6];

    public CubeMap(ResourceLocation pBaseImageLocation) {
        int i = 0;
        while (i < 6) {
            this.images[i] = new ResourceLocation(pBaseImageLocation.getNamespace(), String.valueOf(pBaseImageLocation.getPath()) + "_" + i + ".png");
            ++i;
        }
    }

    public void render(Minecraft pMc, float pPitch, float pYaw, float pAlpha) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        Matrix4f matrix4f = Matrix4f.perspective(85.0, (float)pMc.getWindow().getWidth() / (float)pMc.getWindow().getHeight(), 0.05f, 10.0f);
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix(matrix4f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.pushPose();
        posestack.setIdentity();
        posestack.mulPose(Vector3f.XP.rotationDegrees(180.0f));
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.depthMask(false);
        RenderSystem.defaultBlendFunc();
        int i = 2;
        int j = 0;
        while (j < 4) {
            posestack.pushPose();
            float f = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
            float f1 = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
            float f2 = 0.0f;
            posestack.translate(f, f1, 0.0);
            posestack.mulPose(Vector3f.XP.rotationDegrees(pPitch));
            posestack.mulPose(Vector3f.YP.rotationDegrees(pYaw));
            RenderSystem.applyModelViewMatrix();
            int k = 0;
            while (k < 6) {
                RenderSystem.setShaderTexture(0, this.images[k]);
                bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                int l = Math.round(255.0f * pAlpha) / (j + 1);
                if (k == 0) {
                    bufferbuilder.vertex(-1.0, -1.0, 1.0).uv(0.0f, 0.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(-1.0, 1.0, 1.0).uv(0.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, 1.0, 1.0).uv(1.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, -1.0, 1.0).uv(1.0f, 0.0f).color(255, 255, 255, l).endVertex();
                }
                if (k == 1) {
                    bufferbuilder.vertex(1.0, -1.0, 1.0).uv(0.0f, 0.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, 1.0, 1.0).uv(0.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, 1.0, -1.0).uv(1.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, -1.0, -1.0).uv(1.0f, 0.0f).color(255, 255, 255, l).endVertex();
                }
                if (k == 2) {
                    bufferbuilder.vertex(1.0, -1.0, -1.0).uv(0.0f, 0.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, 1.0, -1.0).uv(0.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(-1.0, 1.0, -1.0).uv(1.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(-1.0, -1.0, -1.0).uv(1.0f, 0.0f).color(255, 255, 255, l).endVertex();
                }
                if (k == 3) {
                    bufferbuilder.vertex(-1.0, -1.0, -1.0).uv(0.0f, 0.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(-1.0, 1.0, -1.0).uv(0.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(-1.0, 1.0, 1.0).uv(1.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(-1.0, -1.0, 1.0).uv(1.0f, 0.0f).color(255, 255, 255, l).endVertex();
                }
                if (k == 4) {
                    bufferbuilder.vertex(-1.0, -1.0, -1.0).uv(0.0f, 0.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(-1.0, -1.0, 1.0).uv(0.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, -1.0, 1.0).uv(1.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, -1.0, -1.0).uv(1.0f, 0.0f).color(255, 255, 255, l).endVertex();
                }
                if (k == 5) {
                    bufferbuilder.vertex(-1.0, 1.0, 1.0).uv(0.0f, 0.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(-1.0, 1.0, -1.0).uv(0.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, 1.0, -1.0).uv(1.0f, 1.0f).color(255, 255, 255, l).endVertex();
                    bufferbuilder.vertex(1.0, 1.0, 1.0).uv(1.0f, 0.0f).color(255, 255, 255, l).endVertex();
                }
                tesselator.end();
                ++k;
            }
            posestack.popPose();
            RenderSystem.applyModelViewMatrix();
            RenderSystem.colorMask(true, true, true, false);
            ++j;
        }
        RenderSystem.colorMask(true, true, true, true);
        RenderSystem.restoreProjectionMatrix();
        posestack.popPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask(true);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
    }

    public CompletableFuture<Void> preload(TextureManager pTexMngr, Executor pBackgroundExecutor) {
        CompletableFuture[] completablefuture = new CompletableFuture[6];
        int i = 0;
        while (i < completablefuture.length) {
            completablefuture[i] = pTexMngr.preload(this.images[i], pBackgroundExecutor);
            ++i;
        }
        return CompletableFuture.allOf(completablefuture);
    }
}

