/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;

public abstract class DimensionSpecialEffects {
    private static final Object2ObjectMap<ResourceLocation, DimensionSpecialEffects> EFFECTS = (Object2ObjectMap)Util.make(new Object2ObjectArrayMap(), p_108881_ -> {
        OverworldEffects dimensionspecialeffects$overworldeffects = new OverworldEffects();
        p_108881_.defaultReturnValue((Object)dimensionspecialeffects$overworldeffects);
        p_108881_.put((Object)DimensionType.OVERWORLD_EFFECTS, (Object)dimensionspecialeffects$overworldeffects);
        p_108881_.put((Object)DimensionType.NETHER_EFFECTS, (Object)new NetherEffects());
        p_108881_.put((Object)DimensionType.END_EFFECTS, (Object)new EndEffects());
    });
    private final float[] sunriseCol = new float[4];
    private final float cloudLevel;
    private final boolean hasGround;
    private final SkyType skyType;
    private final boolean forceBrightLightmap;
    private final boolean constantAmbientLight;

    public DimensionSpecialEffects(float pCloudLevel, boolean pHasGround, SkyType pSkyType, boolean pForceBrightLightmap, boolean pConstantAmbientLight) {
        this.cloudLevel = pCloudLevel;
        this.hasGround = pHasGround;
        this.skyType = pSkyType;
        this.forceBrightLightmap = pForceBrightLightmap;
        this.constantAmbientLight = pConstantAmbientLight;
    }

    public static DimensionSpecialEffects forType(DimensionType pDimensionType) {
        return (DimensionSpecialEffects)EFFECTS.get((Object)pDimensionType.effectsLocation());
    }

    @Nullable
    public float[] getSunriseColor(float pTimeOfDay, float pPartialTicks) {
        float f = 0.4f;
        float f1 = Mth.cos(pTimeOfDay * ((float)Math.PI * 2)) - 0.0f;
        float f2 = -0.0f;
        if (f1 >= -0.4f && f1 <= 0.4f) {
            float f3 = (f1 - -0.0f) / 0.4f * 0.5f + 0.5f;
            float f4 = 1.0f - (1.0f - Mth.sin(f3 * (float)Math.PI)) * 0.99f;
            f4 *= f4;
            this.sunriseCol[0] = f3 * 0.3f + 0.7f;
            this.sunriseCol[1] = f3 * f3 * 0.7f + 0.2f;
            this.sunriseCol[2] = f3 * f3 * 0.0f + 0.2f;
            this.sunriseCol[3] = f4;
            return this.sunriseCol;
        }
        return null;
    }

    public float getCloudHeight() {
        return this.cloudLevel;
    }

    public boolean hasGround() {
        return this.hasGround;
    }

    public abstract Vec3 getBrightnessDependentFogColor(Vec3 var1, float var2);

    public abstract boolean isFoggyAt(int var1, int var2);

    public SkyType skyType() {
        return this.skyType;
    }

    public boolean forceBrightLightmap() {
        return this.forceBrightLightmap;
    }

    public boolean constantAmbientLight() {
        return this.constantAmbientLight;
    }

    public static class EndEffects
    extends DimensionSpecialEffects {
        public EndEffects() {
            super(Float.NaN, false, SkyType.END, true, false);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108894_, float p_108895_) {
            return p_108894_.scale(0.15f);
        }

        @Override
        public boolean isFoggyAt(int p_108891_, int p_108892_) {
            return false;
        }

        @Override
        @Nullable
        public float[] getSunriseColor(float p_108888_, float p_108889_) {
            return null;
        }
    }

    public static class NetherEffects
    extends DimensionSpecialEffects {
        public NetherEffects() {
            super(Float.NaN, true, SkyType.NONE, false, true);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108901_, float p_108902_) {
            return p_108901_;
        }

        @Override
        public boolean isFoggyAt(int p_108898_, int p_108899_) {
            return true;
        }
    }

    public static class OverworldEffects
    extends DimensionSpecialEffects {
        public static final int CLOUD_LEVEL = 192;

        public OverworldEffects() {
            super(192.0f, true, SkyType.NORMAL, false, false);
        }

        @Override
        public Vec3 getBrightnessDependentFogColor(Vec3 p_108908_, float p_108909_) {
            return p_108908_.multiply(p_108909_ * 0.94f + 0.06f, p_108909_ * 0.94f + 0.06f, p_108909_ * 0.91f + 0.09f);
        }

        @Override
        public boolean isFoggyAt(int p_108905_, int p_108906_) {
            return false;
        }
    }

    public static enum SkyType {
        NONE,
        NORMAL,
        END;

    }
}

