/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.shaders.Effect;
import com.mojang.blaze3d.shaders.EffectProgram;
import com.mojang.blaze3d.shaders.Program;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ChainedJsonException;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.optifine.reflect.Reflector;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class EffectInstance
implements Effect,
AutoCloseable {
    private static final String EFFECT_SHADER_PATH = "shaders/program/";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AbstractUniform DUMMY_UNIFORM = new AbstractUniform();
    private static final boolean ALWAYS_REAPPLY = true;
    private static EffectInstance lastAppliedEffect;
    private static int lastProgramId;
    private final Map<String, IntSupplier> samplerMap = Maps.newHashMap();
    private final List<String> samplerNames = Lists.newArrayList();
    private final List<Integer> samplerLocations = Lists.newArrayList();
    private final List<Uniform> uniforms = Lists.newArrayList();
    private final List<Integer> uniformLocations = Lists.newArrayList();
    private final Map<String, Uniform> uniformMap = Maps.newHashMap();
    private final int programId;
    private final String name;
    private boolean dirty;
    private final BlendMode blend;
    private final List<Integer> attributes;
    private final List<String> attributeNames;
    private final EffectProgram vertexProgram;
    private final EffectProgram fragmentProgram;

    static {
        lastProgramId = -1;
    }

    public EffectInstance(ResourceManager pResourceManager, String pName) throws IOException {
        ResourceLocation resourcelocation = new ResourceLocation(EFFECT_SHADER_PATH + pName + ".json");
        if (Reflector.MinecraftForgeClient.exists()) {
            ResourceLocation resourcelocation1 = ResourceLocation.tryParse(pName);
            resourcelocation = new ResourceLocation(resourcelocation1.getNamespace(), EFFECT_SHADER_PATH + resourcelocation1.getPath() + ".json");
        }
        this.name = pName;
        Resource resource = null;
        try {
            try {
                JsonArray jsonarray1;
                resource = pResourceManager.getResource(resourcelocation);
                JsonObject jsonobject = GsonHelper.parse(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
                String s1 = GsonHelper.getAsString(jsonobject, "vertex");
                String s2 = GsonHelper.getAsString(jsonobject, "fragment");
                JsonArray jsonarray = GsonHelper.getAsJsonArray(jsonobject, "samplers", null);
                if (jsonarray != null) {
                    int i = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        try {
                            this.parseSamplerNode(jsonelement);
                        }
                        catch (Exception exception2) {
                            ChainedJsonException chainedjsonexception1 = ChainedJsonException.forException(exception2);
                            chainedjsonexception1.prependJsonKey("samplers[" + i + "]");
                            throw chainedjsonexception1;
                        }
                        ++i;
                    }
                }
                if ((jsonarray1 = GsonHelper.getAsJsonArray(jsonobject, "attributes", null)) != null) {
                    int j = 0;
                    this.attributes = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                    this.attributeNames = Lists.newArrayListWithCapacity((int)jsonarray1.size());
                    for (JsonElement jsonelement1 : jsonarray1) {
                        try {
                            this.attributeNames.add(GsonHelper.convertToString(jsonelement1, "attribute"));
                        }
                        catch (Exception exception1) {
                            ChainedJsonException chainedjsonexception2 = ChainedJsonException.forException(exception1);
                            chainedjsonexception2.prependJsonKey("attributes[" + j + "]");
                            throw chainedjsonexception2;
                        }
                        ++j;
                    }
                } else {
                    this.attributes = null;
                    this.attributeNames = null;
                }
                JsonArray jsonarray2 = GsonHelper.getAsJsonArray(jsonobject, "uniforms", null);
                if (jsonarray2 != null) {
                    int k = 0;
                    for (JsonElement jsonelement2 : jsonarray2) {
                        try {
                            this.parseUniformNode(jsonelement2);
                        }
                        catch (Exception exception1) {
                            ChainedJsonException chainedjsonexception3 = ChainedJsonException.forException(exception1);
                            chainedjsonexception3.prependJsonKey("uniforms[" + k + "]");
                            throw chainedjsonexception3;
                        }
                        ++k;
                    }
                }
                this.blend = EffectInstance.parseBlendNode(GsonHelper.getAsJsonObject(jsonobject, "blend", null));
                this.vertexProgram = EffectInstance.getOrCreate(pResourceManager, Program.Type.VERTEX, s1);
                this.fragmentProgram = EffectInstance.getOrCreate(pResourceManager, Program.Type.FRAGMENT, s2);
                this.programId = ProgramManager.createProgram();
                ProgramManager.linkShader(this);
                this.updateLocations();
                if (this.attributeNames != null) {
                    for (String s3 : this.attributeNames) {
                        int l = Uniform.glGetAttribLocation(this.programId, s3);
                        this.attributes.add(l);
                    }
                }
            }
            catch (Exception exception31) {
                String s = resource != null ? " (" + resource.getSourceName() + ")" : "";
                ChainedJsonException chainedjsonexception = ChainedJsonException.forException(exception31);
                chainedjsonexception.setFilenameAndFlush(String.valueOf(resourcelocation.getPath()) + s);
                throw chainedjsonexception;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(resource);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)resource);
        this.markDirty();
    }

    public static EffectProgram getOrCreate(ResourceManager pResourceManager, Program.Type pProgramType, String pName) throws IOException {
        EffectProgram effectprogram;
        Program program = pProgramType.getPrograms().get(pName);
        if (program != null && !(program instanceof EffectProgram)) {
            throw new InvalidClassException("Program is not of type EffectProgram");
        }
        if (program == null) {
            ResourceLocation resourcelocation = new ResourceLocation(EFFECT_SHADER_PATH + pName + pProgramType.getExtension());
            if (Reflector.MinecraftForgeClient.exists()) {
                ResourceLocation resourcelocation1 = ResourceLocation.tryParse(pName);
                resourcelocation = new ResourceLocation(resourcelocation1.getNamespace(), EFFECT_SHADER_PATH + resourcelocation1.getPath() + pProgramType.getExtension());
            }
            Resource resource = pResourceManager.getResource(resourcelocation);
            try {
                effectprogram = EffectProgram.compileShader(pProgramType, pName, resource.getInputStream(), resource.getSourceName());
            }
            finally {
                IOUtils.closeQuietly((Closeable)resource);
            }
        } else {
            effectprogram = (EffectProgram)program;
        }
        return effectprogram;
    }

    public static BlendMode parseBlendNode(@Nullable JsonObject pJson) {
        if (pJson == null) {
            return new BlendMode();
        }
        int i = 32774;
        int j = 1;
        int k = 0;
        int l = 1;
        int i1 = 0;
        boolean flag = true;
        boolean flag1 = false;
        if (GsonHelper.isStringValue(pJson, "func") && (i = BlendMode.stringToBlendFunc(pJson.get("func").getAsString())) != 32774) {
            flag = false;
        }
        if (GsonHelper.isStringValue(pJson, "srcrgb") && (j = BlendMode.stringToBlendFactor(pJson.get("srcrgb").getAsString())) != 1) {
            flag = false;
        }
        if (GsonHelper.isStringValue(pJson, "dstrgb") && (k = BlendMode.stringToBlendFactor(pJson.get("dstrgb").getAsString())) != 0) {
            flag = false;
        }
        if (GsonHelper.isStringValue(pJson, "srcalpha")) {
            l = BlendMode.stringToBlendFactor(pJson.get("srcalpha").getAsString());
            if (l != 1) {
                flag = false;
            }
            flag1 = true;
        }
        if (GsonHelper.isStringValue(pJson, "dstalpha")) {
            i1 = BlendMode.stringToBlendFactor(pJson.get("dstalpha").getAsString());
            if (i1 != 0) {
                flag = false;
            }
            flag1 = true;
        }
        if (flag) {
            return new BlendMode();
        }
        return flag1 ? new BlendMode(j, k, l, i1, i) : new BlendMode(j, k, i);
    }

    @Override
    public void close() {
        for (Uniform uniform : this.uniforms) {
            uniform.close();
        }
        ProgramManager.releaseProgram(this);
    }

    public void clear() {
        RenderSystem.assertOnRenderThread();
        lastProgramId = -1;
        lastAppliedEffect = null;
        int i = 0;
        while (i < this.samplerLocations.size()) {
            if (this.samplerMap.get(this.samplerNames.get(i)) != null) {
                GlStateManager._activeTexture(33984 + i);
                GlStateManager._disableTexture();
                GlStateManager._bindTexture(0);
            }
            ++i;
        }
    }

    public void apply() {
        RenderSystem.assertOnGameThread();
        this.dirty = false;
        lastAppliedEffect = this;
        this.blend.apply();
        if (this.programId != GlStateManager.getProgram()) {
            ProgramManager.glUseProgram(this.programId);
            lastProgramId = this.programId;
        }
        int i = 0;
        while (i < this.samplerLocations.size()) {
            String s = this.samplerNames.get(i);
            IntSupplier intsupplier = this.samplerMap.get(s);
            if (intsupplier != null) {
                RenderSystem.activeTexture(33984 + i);
                RenderSystem.enableTexture();
                int j = intsupplier.getAsInt();
                if (j != -1) {
                    RenderSystem.bindTexture(j);
                    Uniform.uploadInteger(this.samplerLocations.get(i), i);
                }
            }
            ++i;
        }
        for (Uniform uniform : this.uniforms) {
            uniform.upload();
        }
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Nullable
    public Uniform getUniform(String pName) {
        RenderSystem.assertOnRenderThread();
        return this.uniformMap.get(pName);
    }

    public AbstractUniform safeGetUniform(String pName) {
        RenderSystem.assertOnGameThread();
        Uniform uniform = this.getUniform(pName);
        return uniform == null ? DUMMY_UNIFORM : uniform;
    }

    private void updateLocations() {
        RenderSystem.assertOnRenderThread();
        IntArrayList intlist = new IntArrayList();
        int i = 0;
        while (i < this.samplerNames.size()) {
            String s = this.samplerNames.get(i);
            int j = Uniform.glGetUniformLocation(this.programId, s);
            if (j == -1) {
                LOGGER.warn("Shader {} could not find sampler named {} in the specified shader program.", (Object)this.name, (Object)s);
                this.samplerMap.remove(s);
                intlist.add(i);
            } else {
                this.samplerLocations.add(j);
            }
            ++i;
        }
        int l = intlist.size() - 1;
        while (l >= 0) {
            this.samplerNames.remove(intlist.getInt(l));
            --l;
        }
        for (Uniform uniform : this.uniforms) {
            String s1 = uniform.getName();
            int k = Uniform.glGetUniformLocation(this.programId, s1);
            if (k == -1) {
                LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)this.name, (Object)s1);
                continue;
            }
            this.uniformLocations.add(k);
            uniform.setLocation(k);
            this.uniformMap.put(s1, uniform);
        }
    }

    private void parseSamplerNode(JsonElement pJson) {
        JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "sampler");
        String s = GsonHelper.getAsString(jsonobject, "name");
        if (!GsonHelper.isStringValue(jsonobject, "file")) {
            this.samplerMap.put(s, null);
            this.samplerNames.add(s);
        } else {
            this.samplerNames.add(s);
        }
    }

    public void setSampler(String pName, IntSupplier pTextureId) {
        if (this.samplerMap.containsKey(pName)) {
            this.samplerMap.remove(pName);
        }
        this.samplerMap.put(pName, pTextureId);
        this.markDirty();
    }

    private void parseUniformNode(JsonElement pJson) throws ChainedJsonException {
        JsonObject jsonobject = GsonHelper.convertToJsonObject(pJson, "uniform");
        String s = GsonHelper.getAsString(jsonobject, "name");
        int i = Uniform.getTypeFromString(GsonHelper.getAsString(jsonobject, "type"));
        int j = GsonHelper.getAsInt(jsonobject, "count");
        float[] afloat = new float[Math.max(j, 16)];
        JsonArray jsonarray = GsonHelper.getAsJsonArray(jsonobject, "values");
        if (jsonarray.size() != j && jsonarray.size() > 1) {
            throw new ChainedJsonException("Invalid amount of values specified (expected " + j + ", found " + jsonarray.size() + ")");
        }
        int k = 0;
        for (JsonElement jsonelement : jsonarray) {
            try {
                afloat[k] = GsonHelper.convertToFloat(jsonelement, "value");
            }
            catch (Exception exception) {
                ChainedJsonException chainedjsonexception = ChainedJsonException.forException(exception);
                chainedjsonexception.prependJsonKey("values[" + k + "]");
                throw chainedjsonexception;
            }
            ++k;
        }
        if (j > 1 && jsonarray.size() == 1) {
            while (k < j) {
                afloat[k] = afloat[0];
                ++k;
            }
        }
        int l = j > 1 && j <= 4 && i < 8 ? j - 1 : 0;
        Uniform uniform = new Uniform(s, i + l, j, this);
        if (i <= 3) {
            uniform.setSafe((int)afloat[0], (int)afloat[1], (int)afloat[2], (int)afloat[3]);
        } else if (i <= 7) {
            uniform.setSafe(afloat[0], afloat[1], afloat[2], afloat[3]);
        } else {
            uniform.a(afloat);
        }
        this.uniforms.add(uniform);
    }

    @Override
    public Program getVertexProgram() {
        return this.vertexProgram;
    }

    @Override
    public Program getFragmentProgram() {
        return this.fragmentProgram;
    }

    @Override
    public void attachToProgram() {
        this.fragmentProgram.attachToEffect(this);
        this.vertexProgram.attachToEffect(this);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.programId;
    }
}

