/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.reflect.Reflector;
import net.optifine.render.GLConst;
import net.optifine.shaders.Shaders;

public class FogRenderer {
    private static final int WATER_FOG_DISTANCE = 96;
    public static final float BIOME_FOG_TRANSITION_TIME = 5000.0f;
    public static float fogRed;
    public static float fogGreen;
    public static float fogBlue;
    private static int targetBiomeFog;
    private static int previousBiomeFog;
    private static long biomeChangedTime;
    public static boolean fogStandard;

    static {
        targetBiomeFog = -1;
        previousBiomeFog = -1;
        biomeChangedTime = -1L;
        fogStandard = false;
    }

    public static void setupColor(Camera pActiveRenderInfo, float pPartialTicks, ClientLevel pLevel, int pRenderDistanceChunks, float pBossColorModifier) {
        Entity entity2;
        Vec3 vec32;
        FogType fogtype = pActiveRenderInfo.getFluidInCamera();
        Entity entity = pActiveRenderInfo.getEntity();
        if (fogtype == FogType.WATER) {
            long i = Util.getMillis();
            int j = pLevel.getBiome(new BlockPos(pActiveRenderInfo.getPosition())).value().getWaterFogColor();
            if (biomeChangedTime < 0L) {
                targetBiomeFog = j;
                previousBiomeFog = j;
                biomeChangedTime = i;
            }
            int k = targetBiomeFog >> 16 & 0xFF;
            int l = targetBiomeFog >> 8 & 0xFF;
            int i1 = targetBiomeFog & 0xFF;
            int j1 = previousBiomeFog >> 16 & 0xFF;
            int k1 = previousBiomeFog >> 8 & 0xFF;
            int l1 = previousBiomeFog & 0xFF;
            float f = Mth.clamp((float)(i - biomeChangedTime) / 5000.0f, 0.0f, 1.0f);
            float f1 = Mth.lerp(f, j1, k);
            float f2 = Mth.lerp(f, k1, l);
            float f3 = Mth.lerp(f, l1, i1);
            fogRed = f1 / 255.0f;
            fogGreen = f2 / 255.0f;
            fogBlue = f3 / 255.0f;
            if (targetBiomeFog != j) {
                targetBiomeFog = j;
                previousBiomeFog = Mth.floor(f1) << 16 | Mth.floor(f2) << 8 | Mth.floor(f3);
                biomeChangedTime = i;
            }
        } else if (fogtype == FogType.LAVA) {
            fogRed = 0.6f;
            fogGreen = 0.1f;
            fogBlue = 0.0f;
            biomeChangedTime = -1L;
        } else if (fogtype == FogType.POWDER_SNOW) {
            fogRed = 0.623f;
            fogGreen = 0.734f;
            fogBlue = 0.785f;
            biomeChangedTime = -1L;
            RenderSystem.clearColor(fogRed, fogGreen, fogBlue, 0.0f);
        } else {
            float f15;
            float f4 = 0.25f + 0.75f * (float)pRenderDistanceChunks / 32.0f;
            f4 = 1.0f - (float)Math.pow(f4, 0.25);
            Vec3 vec3 = pLevel.getSkyColor(pActiveRenderInfo.getPosition(), pPartialTicks);
            vec3 = CustomColors.getWorldSkyColor(vec3, pLevel, pActiveRenderInfo.getEntity(), pPartialTicks);
            float f7 = (float)vec3.x;
            float f9 = (float)vec3.y;
            float f10 = (float)vec3.z;
            float f11 = Mth.clamp(Mth.cos(pLevel.getTimeOfDay(pPartialTicks) * ((float)Math.PI * 2)) * 2.0f + 0.5f, 0.0f, 1.0f);
            BiomeManager biomemanager = pLevel.getBiomeManager();
            Vec3 vec33 = pActiveRenderInfo.getPosition().subtract(2.0, 2.0, 2.0).scale(0.25);
            Vec3 vec34 = CubicSampler.gaussianSampleVec3(vec33, (xIn, yIn, zIn) -> pLevel.effects().getBrightnessDependentFogColor(Vec3.fromRGB24(biomemanager.getNoiseBiomeAtQuart(xIn, yIn, zIn).value().getFogColor()), f11));
            vec34 = CustomColors.getWorldFogColor(vec34, pLevel, pActiveRenderInfo.getEntity(), pPartialTicks);
            fogRed = (float)vec34.x();
            fogGreen = (float)vec34.y();
            fogBlue = (float)vec34.z();
            if (pRenderDistanceChunks >= 4) {
                float[] afloat;
                float f12 = Mth.sin(pLevel.getSunAngle(pPartialTicks)) > 0.0f ? -1.0f : 1.0f;
                Vector3f vector3f = new Vector3f(f12, 0.0f, 0.0f);
                float f16 = pActiveRenderInfo.getLookVector().dot(vector3f);
                if (f16 < 0.0f) {
                    f16 = 0.0f;
                }
                if (f16 > 0.0f && (afloat = pLevel.effects().getSunriseColor(pLevel.getTimeOfDay(pPartialTicks), pPartialTicks)) != null) {
                    fogRed = fogRed * (1.0f - (f16 *= afloat[3])) + afloat[0] * f16;
                    fogGreen = fogGreen * (1.0f - f16) + afloat[1] * f16;
                    fogBlue = fogBlue * (1.0f - f16) + afloat[2] * f16;
                }
            }
            fogRed += (f7 - fogRed) * f4;
            fogGreen += (f9 - fogGreen) * f4;
            fogBlue += (f10 - fogBlue) * f4;
            float f13 = pLevel.getRainLevel(pPartialTicks);
            if (f13 > 0.0f) {
                float f14 = 1.0f - f13 * 0.5f;
                float f17 = 1.0f - f13 * 0.4f;
                fogRed *= f14;
                fogGreen *= f14;
                fogBlue *= f17;
            }
            if ((f15 = pLevel.getThunderLevel(pPartialTicks)) > 0.0f) {
                float f18 = 1.0f - f15 * 0.5f;
                fogRed *= f18;
                fogGreen *= f18;
                fogBlue *= f18;
            }
            biomeChangedTime = -1L;
        }
        float f5 = ((float)pActiveRenderInfo.getPosition().y - (float)pLevel.getMinBuildHeight()) * pLevel.getLevelData().getClearColorScale();
        if (pActiveRenderInfo.getEntity() instanceof LivingEntity && ((LivingEntity)pActiveRenderInfo.getEntity()).hasEffect(MobEffects.BLINDNESS)) {
            int i2 = ((LivingEntity)pActiveRenderInfo.getEntity()).getEffect(MobEffects.BLINDNESS).getDuration();
            f5 = i2 < 20 ? 1.0f - (float)i2 / 20.0f : 0.0f;
        }
        if (f5 < 1.0f && fogtype != FogType.LAVA && fogtype != FogType.POWDER_SNOW) {
            if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            f5 *= f5;
            fogRed *= f5;
            fogGreen *= f5;
            fogBlue *= f5;
        }
        if (pBossColorModifier > 0.0f) {
            fogRed = fogRed * (1.0f - pBossColorModifier) + fogRed * 0.7f * pBossColorModifier;
            fogGreen = fogGreen * (1.0f - pBossColorModifier) + fogGreen * 0.6f * pBossColorModifier;
            fogBlue = fogBlue * (1.0f - pBossColorModifier) + fogBlue * 0.6f * pBossColorModifier;
        }
        float f6 = fogtype == FogType.WATER ? (entity instanceof LocalPlayer ? ((LocalPlayer)entity).getWaterVision() : 1.0f) : (entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(MobEffects.NIGHT_VISION) ? GameRenderer.getNightVisionScale((LivingEntity)entity, pPartialTicks) : 0.0f);
        if (fogRed != 0.0f && fogGreen != 0.0f && fogBlue != 0.0f) {
            float f8 = Math.min(1.0f / fogRed, Math.min(1.0f / fogGreen, 1.0f / fogBlue));
            fogRed = fogRed * (1.0f - f6) + fogRed * f8 * f6;
            fogGreen = fogGreen * (1.0f - f6) + fogGreen * f8 * f6;
            fogBlue = fogBlue * (1.0f - f6) + fogBlue * f8 * f6;
        }
        if (fogtype == FogType.WATER) {
            Entity entity1 = pActiveRenderInfo.getEntity();
            Vec3 vec31 = CustomColors.getUnderwaterColor(pLevel, entity1.getX(), entity1.getY() + 1.0, entity1.getZ());
            if (vec31 != null) {
                fogRed = (float)vec31.x;
                fogGreen = (float)vec31.y;
                fogBlue = (float)vec31.z;
            }
        } else if (fogtype == FogType.LAVA && (vec32 = CustomColors.getUnderlavaColor(pLevel, (entity2 = pActiveRenderInfo.getEntity()).getX(), entity2.getY() + 1.0, entity2.getZ())) != null) {
            fogRed = (float)vec32.x;
            fogGreen = (float)vec32.y;
            fogBlue = (float)vec32.z;
        }
        if (Reflector.EntityViewRenderEvent_FogColors_Constructor.exists()) {
            Object object = Reflector.newInstance(Reflector.EntityViewRenderEvent_FogColors_Constructor, pActiveRenderInfo, Float.valueOf(pPartialTicks), Float.valueOf(fogRed), Float.valueOf(fogGreen), Float.valueOf(fogBlue));
            Reflector.postForgeBusEvent(object);
            fogRed = Reflector.callFloat(object, Reflector.EntityViewRenderEvent_FogColors_getRed, new Object[0]);
            fogGreen = Reflector.callFloat(object, Reflector.EntityViewRenderEvent_FogColors_getGreen, new Object[0]);
            fogBlue = Reflector.callFloat(object, Reflector.EntityViewRenderEvent_FogColors_getBlue, new Object[0]);
        }
        Shaders.setClearColor(fogRed, fogGreen, fogBlue, 0.0f);
        RenderSystem.clearColor(fogRed, fogGreen, fogBlue, 0.0f);
    }

    public static void setupNoFog() {
        RenderSystem.setShaderFogStart(Float.MAX_VALUE);
        if (Config.isShaders()) {
            Shaders.setFogDensity(0.0f);
            Shaders.setFogMode(GLConst.GL_EXP2);
            Shaders.setFogStart(1.7014117E38f);
            Shaders.setFogEnd(Float.MAX_VALUE);
        }
    }

    public static void setupFog(Camera pActiveRenderInfo, FogMode pFogType, float pFarPlaneDistance, boolean pNearFog) {
        FogRenderer.setupFog(pActiveRenderInfo, pFogType, pFarPlaneDistance, pNearFog, 0.0f);
    }

    public static void setupFog(Camera activeRenderInfoIn, FogMode fogTypeIn, float farPlaneDistance, boolean nearFog, float partialTicks) {
        float f1;
        float f;
        fogStandard = false;
        FogType fogtype = activeRenderInfoIn.getFluidInCamera();
        Entity entity = activeRenderInfoIn.getEntity();
        FogShape fogshape = FogShape.SPHERE;
        float f2 = -1.0f;
        if (Reflector.ForgeHooksClient_getFogDensity.exists()) {
            f2 = Reflector.callFloat(Reflector.ForgeHooksClient_getFogDensity, new Object[]{fogTypeIn, activeRenderInfoIn, Float.valueOf(partialTicks), Float.valueOf(0.1f)});
        }
        if (f2 >= 0.0f) {
            RenderSystem.setShaderFogStart(-8.0f);
            RenderSystem.setShaderFogEnd(f2 * 0.5f);
            f = -8.0f;
            f1 = f2 * 0.5f;
            if (Config.isShaders()) {
                Shaders.setFogDensity(f2);
            }
        } else if (fogtype == FogType.LAVA) {
            if (entity.isSpectator()) {
                f = -8.0f;
                f1 = farPlaneDistance * 0.5f;
            } else if (entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(MobEffects.FIRE_RESISTANCE)) {
                f = 0.0f;
                f1 = 3.0f;
            } else {
                f = 0.25f;
                f1 = 1.0f;
            }
        } else if (fogtype == FogType.POWDER_SNOW) {
            if (entity.isSpectator()) {
                f = -8.0f;
                f1 = farPlaneDistance * 0.5f;
            } else {
                f = 0.0f;
                f1 = 2.0f;
            }
        } else if (entity instanceof LivingEntity && ((LivingEntity)entity).hasEffect(MobEffects.BLINDNESS)) {
            int i = ((LivingEntity)entity).getEffect(MobEffects.BLINDNESS).getDuration();
            float f4 = Mth.lerp(Math.min(1.0f, (float)i / 20.0f), farPlaneDistance, 5.0f);
            if (fogTypeIn == FogMode.FOG_SKY) {
                f = 0.0f;
                f1 = f4 * 0.8f;
            } else {
                f = fogtype == FogType.WATER ? -4.0f : f4 * 0.25f;
                f1 = f4;
            }
        } else if (fogtype == FogType.WATER) {
            f = -8.0f;
            f1 = 96.0f;
            if (entity instanceof LocalPlayer) {
                LocalPlayer localplayer = (LocalPlayer)entity;
                f1 *= Math.max(0.25f, localplayer.getWaterVision());
                Holder<Biome> holder = localplayer.level.getBiome(localplayer.blockPosition());
                if (Biome.getBiomeCategory(holder) == Biome.BiomeCategory.SWAMP) {
                    f1 *= 0.85f;
                }
            }
            if (f1 > farPlaneDistance) {
                f1 = farPlaneDistance;
                fogshape = FogShape.CYLINDER;
            }
        } else if (nearFog) {
            fogStandard = true;
            f = farPlaneDistance * 0.05f;
            f1 = Math.min(farPlaneDistance, 192.0f) * 0.5f;
        } else if (fogTypeIn == FogMode.FOG_SKY) {
            f = 0.0f;
            f1 = Math.min(farPlaneDistance, 512.0f);
            fogshape = FogShape.CYLINDER;
        } else {
            fogStandard = true;
            float f3 = Mth.clamp(farPlaneDistance / 10.0f, 4.0f, 64.0f);
            f = farPlaneDistance * Config.getFogStart();
            f1 = farPlaneDistance;
            fogshape = FogShape.CYLINDER;
        }
        RenderSystem.setShaderFogStart(f);
        RenderSystem.setShaderFogEnd(f1);
        RenderSystem.setShaderFogShape(fogshape);
        if (Config.isShaders()) {
            Shaders.setFogStart(f);
            Shaders.setFogEnd(f1);
            Shaders.setFogMode(9729);
            Shaders.setFogShape(fogshape.ordinal());
        }
        if (Reflector.ForgeHooksClient_onFogRender.exists()) {
            Reflector.callVoid(Reflector.ForgeHooksClient_onFogRender, new Object[]{fogTypeIn, activeRenderInfoIn, Float.valueOf(partialTicks), Float.valueOf(f), Float.valueOf(f1), fogshape});
        }
    }

    public static void levelFogColor() {
        RenderSystem.setShaderFogColor(fogRed, fogGreen, fogBlue);
        if (Config.isShaders()) {
            Shaders.setFogColor(fogRed, fogGreen, fogBlue);
        }
    }

    public static enum FogMode {
        FOG_SKY,
        FOG_TERRAIN;

    }
}

