/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.shaders.Shaders;
import net.optifine.util.TextureUtils;

public class LightTexture
implements AutoCloseable {
    public static final int FULL_BRIGHT = 0xF000F0;
    public static final int FULL_SKY = 0xF00000;
    public static final int FULL_BLOCK = 240;
    private final DynamicTexture lightTexture;
    private final NativeImage lightPixels;
    private final ResourceLocation lightTextureLocation;
    private boolean updateLightTexture;
    private float blockLightRedFlicker;
    private final GameRenderer renderer;
    private final Minecraft minecraft;
    private boolean allowed = true;
    private boolean custom = false;
    private Vector3f tempVector = new Vector3f();
    public static final int MAX_BRIGHTNESS = LightTexture.pack(15, 15);

    public LightTexture(GameRenderer pRenderer, Minecraft pMinecraft) {
        this.renderer = pRenderer;
        this.minecraft = pMinecraft;
        this.lightTexture = new DynamicTexture(16, 16, false);
        this.lightTextureLocation = this.minecraft.getTextureManager().register("light_map", this.lightTexture);
        this.lightPixels = this.lightTexture.getPixels();
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 16) {
                this.lightPixels.setPixelRGBA(j, i, -1);
                ++j;
            }
            ++i;
        }
        this.lightTexture.upload();
    }

    @Override
    public void close() {
        this.lightTexture.close();
    }

    public void tick() {
        this.blockLightRedFlicker += (float)((Math.random() - Math.random()) * Math.random() * Math.random() * 0.1);
        this.blockLightRedFlicker *= 0.9f;
        this.updateLightTexture = true;
    }

    public void turnOffLightLayer() {
        RenderSystem.setShaderTexture(2, 0);
        if (Config.isShaders()) {
            Shaders.disableLightmap();
        }
    }

    public void turnOnLightLayer() {
        if (!this.allowed) {
            RenderSystem.setShaderTexture(2, TextureUtils.WHITE_TEXTURE_LOCATION);
            this.minecraft.getTextureManager().bindForSetup(TextureUtils.WHITE_TEXTURE_LOCATION);
        } else {
            RenderSystem.setShaderTexture(2, this.lightTextureLocation);
            this.minecraft.getTextureManager().bindForSetup(this.lightTextureLocation);
        }
        RenderSystem.texParameter(3553, 10241, 9729);
        RenderSystem.texParameter(3553, 10240, 9729);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (Config.isShaders()) {
            Shaders.enableLightmap();
        }
    }

    public void updateLightTexture(float pPartialTicks) {
        if (this.updateLightTexture) {
            this.updateLightTexture = false;
            this.minecraft.getProfiler().push("lightTex");
            ClientLevel clientlevel = this.minecraft.level;
            if (clientlevel != null) {
                this.custom = false;
                if (Config.isCustomColors()) {
                    boolean flag;
                    boolean bl = flag = this.minecraft.player.hasEffect(MobEffects.NIGHT_VISION) || this.minecraft.player.hasEffect(MobEffects.CONDUIT_POWER);
                    if (CustomColors.updateLightmap(clientlevel, this.blockLightRedFlicker, this.lightPixels, flag, pPartialTicks)) {
                        this.lightTexture.upload();
                        this.updateLightTexture = false;
                        this.minecraft.getProfiler().pop();
                        this.custom = true;
                        return;
                    }
                }
                float f9 = clientlevel.getSkyDarken(1.0f);
                float f = clientlevel.getSkyFlashTime() > 0 ? 1.0f : f9 * 0.95f + 0.05f;
                float f1 = this.minecraft.player.getWaterVision();
                float f2 = this.minecraft.player.hasEffect(MobEffects.NIGHT_VISION) ? GameRenderer.getNightVisionScale(this.minecraft.player, pPartialTicks) : (f1 > 0.0f && this.minecraft.player.hasEffect(MobEffects.CONDUIT_POWER) ? f1 : 0.0f);
                Vector3f vector3f = new Vector3f(f9, f9, 1.0f);
                vector3f.lerp(new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
                float f3 = this.blockLightRedFlicker + 1.5f;
                Vector3f vector3f1 = new Vector3f();
                int i = 0;
                while (i < 16) {
                    int j = 0;
                    while (j < 16) {
                        float f10;
                        float f4 = this.getBrightness(clientlevel, i) * f;
                        float f5 = this.getBrightness(clientlevel, j) * f3;
                        float f6 = f5 * ((f5 * 0.6f + 0.4f) * 0.6f + 0.4f);
                        float f7 = f5 * (f5 * f5 * 0.6f + 0.4f);
                        vector3f1.set(f5, f6, f7);
                        if (clientlevel.effects().forceBrightLightmap()) {
                            vector3f1.lerp(this.getTempVector3f(0.99f, 1.12f, 1.0f), 0.25f);
                        } else {
                            Vector3f vector3f2 = this.getTempCopy(vector3f);
                            vector3f2.mul(f4);
                            vector3f1.add(vector3f2);
                            vector3f1.lerp(this.getTempVector3f(0.75f, 0.75f, 0.75f), 0.04f);
                            if (this.renderer.getDarkenWorldAmount(pPartialTicks) > 0.0f) {
                                float f8 = this.renderer.getDarkenWorldAmount(pPartialTicks);
                                Vector3f vector3f3 = this.getTempCopy(vector3f1);
                                vector3f3.mul(0.7f, 0.6f, 0.6f);
                                vector3f1.lerp(vector3f3, f8);
                            }
                        }
                        vector3f1.clamp(0.0f, 1.0f);
                        if (f2 > 0.0f && (f10 = Math.max(vector3f1.x(), Math.max(vector3f1.y(), vector3f1.z()))) < 1.0f) {
                            float f12 = 1.0f / f10;
                            Vector3f vector3f5 = this.getTempCopy(vector3f1);
                            vector3f5.mul(f12);
                            vector3f1.lerp(vector3f5, f2);
                        }
                        float f11 = (float)this.minecraft.options.gamma;
                        Vector3f vector3f4 = this.getTempCopy(vector3f1);
                        vector3f4.map(this::notGamma);
                        vector3f1.lerp(vector3f4, f11);
                        vector3f1.lerp(this.getTempVector3f(0.75f, 0.75f, 0.75f), 0.04f);
                        vector3f1.clamp(0.0f, 1.0f);
                        vector3f1.mul(255.0f);
                        int j1 = 255;
                        int k = (int)vector3f1.x();
                        int l = (int)vector3f1.y();
                        int i1 = (int)vector3f1.z();
                        this.lightPixels.setPixelRGBA(j, i, 0xFF000000 | i1 << 16 | l << 8 | k);
                        ++j;
                    }
                    ++i;
                }
                this.lightTexture.upload();
                this.minecraft.getProfiler().pop();
            }
        }
    }

    private float notGamma(float p_109893_) {
        float f = 1.0f - p_109893_;
        return 1.0f - f * f * f * f;
    }

    private float getBrightness(Level pLevel, int pLightLevel) {
        return pLevel.dimensionType().brightness(pLightLevel);
    }

    public static int pack(int pBlockLight, int pSkyLight) {
        return pBlockLight << 4 | pSkyLight << 20;
    }

    public static int block(int pPackedLight) {
        return (pPackedLight & 0xFFFF) >> 4;
    }

    public static int sky(int pPackedLight) {
        return pPackedLight >> 20 & 0xFFFF;
    }

    private Vector3f getTempVector3f(float x, float y, float z) {
        this.tempVector.set(x, y, z);
        return this.tempVector;
    }

    private Vector3f getTempCopy(Vector3f vec) {
        this.tempVector.set(vec.x(), vec.y(), vec.z());
        return this.tempVector;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public boolean isCustom() {
        return this.custom;
    }
}

