/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

public class OutlineBufferSource
implements MultiBufferSource {
    private final MultiBufferSource.BufferSource bufferSource;
    private final MultiBufferSource.BufferSource outlineBufferSource = MultiBufferSource.immediate(new BufferBuilder(256));
    private int teamR = 255;
    private int teamG = 255;
    private int teamB = 255;
    private int teamA = 255;

    public OutlineBufferSource(MultiBufferSource.BufferSource pBufferSource) {
        this.bufferSource = pBufferSource;
    }

    @Override
    public VertexConsumer getBuffer(RenderType pRenderType) {
        if (pRenderType.isOutline()) {
            VertexConsumer vertexconsumer2 = this.outlineBufferSource.getBuffer(pRenderType);
            return new EntityOutlineGenerator(vertexconsumer2, this.teamR, this.teamG, this.teamB, this.teamA);
        }
        VertexConsumer vertexconsumer = this.bufferSource.getBuffer(pRenderType);
        Optional<RenderType> optional = pRenderType.outline();
        if (optional.isPresent()) {
            VertexConsumer vertexconsumer1 = this.outlineBufferSource.getBuffer(optional.get());
            EntityOutlineGenerator outlinebuffersource$entityoutlinegenerator = new EntityOutlineGenerator(vertexconsumer1, this.teamR, this.teamG, this.teamB, this.teamA);
            return VertexMultiConsumer.create(outlinebuffersource$entityoutlinegenerator, vertexconsumer);
        }
        return vertexconsumer;
    }

    public void setColor(int pRed, int pGreen, int pBlue, int pAlpha) {
        this.teamR = pRed;
        this.teamG = pGreen;
        this.teamB = pBlue;
        this.teamA = pAlpha;
    }

    public void endOutlineBatch() {
        this.outlineBufferSource.endBatch();
    }

    static class EntityOutlineGenerator
    extends DefaultedVertexConsumer {
        private final VertexConsumer delegate;
        private double x;
        private double y;
        private double z;
        private float u;
        private float v;

        EntityOutlineGenerator(VertexConsumer pDelegate, int pDefaultR, int pDefaultG, int pDefaultB, int pDefaultA) {
            this.delegate = pDelegate;
            super.defaultColor(pDefaultR, pDefaultG, pDefaultB, pDefaultA);
        }

        @Override
        public void defaultColor(int pRed, int pGreen, int pBlue, int pAlpha) {
        }

        @Override
        public void unsetDefaultColor() {
        }

        @Override
        public VertexConsumer vertex(double pX, double p_109957_, double pY) {
            this.x = pX;
            this.y = p_109957_;
            this.z = pY;
            return this;
        }

        @Override
        public VertexConsumer color(int pRed, int pGreen, int pBlue, int pAlpha) {
            return this;
        }

        @Override
        public VertexConsumer uv(float pU, float pV) {
            this.u = pU;
            this.v = pV;
            return this;
        }

        @Override
        public VertexConsumer overlayCoords(int pU, int pV) {
            return this;
        }

        @Override
        public VertexConsumer uv2(int pU, int pV) {
            return this;
        }

        @Override
        public VertexConsumer normal(float pX, float pY, float pZ) {
            return this;
        }

        @Override
        public void vertex(float pX, float pY, float pZ, float pRed, float pGreen, float pBlue, float pAlpha, float pTexU, float pTexV, int pOverlayUV, int pLightmapUV, float pNormalX, float pNormalY, float pNormalZ) {
            this.delegate.vertex(pX, pY, pZ).color(this.defaultR, this.defaultG, this.defaultB, this.defaultA).uv(pTexU, pTexV).endVertex();
        }

        @Override
        public void endVertex() {
            this.delegate.vertex(this.x, this.y, this.z).color(this.defaultR, this.defaultG, this.defaultB, this.defaultA).uv(this.u, this.v).endVertex();
        }
    }
}

