/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.vertex.BufferBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.SortedMap;
import net.minecraft.Util;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.ModelBakery;

public class RenderBuffers {
    private final ChunkBufferBuilderPack fixedBufferPack = new ChunkBufferBuilderPack();
    private final SortedMap<RenderType, BufferBuilder> fixedBuffers = (SortedMap)Util.make(new Object2ObjectLinkedOpenHashMap(), p_110100_ -> {
        p_110100_.put((Object)Sheets.solidBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.solid()));
        p_110100_.put((Object)Sheets.cutoutBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.cutout()));
        p_110100_.put((Object)Sheets.bannerSheet(), (Object)this.fixedBufferPack.builder(RenderType.cutoutMipped()));
        p_110100_.put((Object)Sheets.translucentCullBlockSheet(), (Object)this.fixedBufferPack.builder(RenderType.translucent()));
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, Sheets.shieldSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, Sheets.bedSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, Sheets.shulkerBoxSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, Sheets.signSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, Sheets.chestSheet());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.translucentNoCrumbling());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.armorGlint());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.armorEntityGlint());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.glint());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.glintDirect());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.glintTranslucent());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.entityGlint());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.entityGlintDirect());
        RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, RenderType.waterMask());
        ModelBakery.DESTROY_TYPES.forEach(p_173062_ -> RenderBuffers.put((Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder>)p_110100_, p_173062_));
    });
    private final MultiBufferSource.BufferSource bufferSource = MultiBufferSource.immediateWithBuffers(this.fixedBuffers, new BufferBuilder(256));
    private final MultiBufferSource.BufferSource crumblingBufferSource = MultiBufferSource.immediate(new BufferBuilder(256));
    private final OutlineBufferSource outlineBufferSource = new OutlineBufferSource(this.bufferSource);

    private static void put(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> pMapBuilders, RenderType pRenderType) {
        pMapBuilders.put((Object)pRenderType, (Object)new BufferBuilder(pRenderType.bufferSize()));
    }

    public ChunkBufferBuilderPack fixedBufferPack() {
        return this.fixedBufferPack;
    }

    public MultiBufferSource.BufferSource bufferSource() {
        return this.bufferSource;
    }

    public MultiBufferSource.BufferSource crumblingBufferSource() {
        return this.crumblingBufferSource;
    }

    public OutlineBufferSource outlineBufferSource() {
        return this.outlineBufferSource;
    }
}

