/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.shaders.Shaders;
import org.apache.commons.lang3.tuple.Pair;

public class ScreenEffectRenderer {
    private static final ResourceLocation UNDERWATER_LOCATION = new ResourceLocation("textures/misc/underwater.png");

    public static void renderScreenEffect(Minecraft pMinecraft, PoseStack pPoseStack) {
        LocalPlayer player = pMinecraft.player;
        if (!player.noPhysics) {
            if (Reflector.ForgeEventFactory_renderBlockOverlay.exists() && Reflector.ForgeBlockModelShapes_getTexture3.exists()) {
                Object object;
                Pair<BlockState, BlockPos> pair = ScreenEffectRenderer.getOverlayBlock(player);
                if (pair != null && !Reflector.ForgeEventFactory_renderBlockOverlay.callBoolean(player, pPoseStack, object = Reflector.getFieldValue(Reflector.RenderBlockOverlayEvent_OverlayType_BLOCK), pair.getLeft(), pair.getRight())) {
                    TextureAtlasSprite textureatlassprite = (TextureAtlasSprite)Reflector.call(pMinecraft.getBlockRenderer().getBlockModelShaper(), Reflector.ForgeBlockModelShapes_getTexture3, pair.getLeft(), pMinecraft.level, pair.getRight());
                    ScreenEffectRenderer.renderTex(textureatlassprite, pPoseStack);
                }
            } else {
                BlockState blockstate = ScreenEffectRenderer.getViewBlockingState(player);
                if (blockstate != null) {
                    ScreenEffectRenderer.renderTex(pMinecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(blockstate), pPoseStack);
                }
            }
        }
        if (!pMinecraft.player.isSpectator()) {
            if (pMinecraft.player.isEyeInFluid(FluidTags.WATER) && !Reflector.ForgeEventFactory_renderWaterOverlay.callBoolean(player, pPoseStack)) {
                ScreenEffectRenderer.renderWater(pMinecraft, pPoseStack);
            }
            if (pMinecraft.player.isOnFire() && !Reflector.ForgeEventFactory_renderFireOverlay.callBoolean(player, pPoseStack)) {
                ScreenEffectRenderer.renderFire(pMinecraft, pPoseStack);
            }
        }
    }

    @Nullable
    private static BlockState getViewBlockingState(Player pPlayer) {
        Pair<BlockState, BlockPos> pair = ScreenEffectRenderer.getOverlayBlock(pPlayer);
        return pair == null ? null : (BlockState)pair.getLeft();
    }

    private static Pair<BlockState, BlockPos> getOverlayBlock(Player playerIn) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = 0;
        while (i < 8) {
            double d0 = playerIn.getX() + (double)(((float)((i >> 0) % 2) - 0.5f) * playerIn.getBbWidth() * 0.8f);
            double d1 = playerIn.getEyeY() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double d2 = playerIn.getZ() + (double)(((float)((i >> 2) % 2) - 0.5f) * playerIn.getBbWidth() * 0.8f);
            blockpos$mutableblockpos.set(d0, d1, d2);
            BlockState blockstate = playerIn.level.getBlockState(blockpos$mutableblockpos);
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE && blockstate.isViewBlocking(playerIn.level, blockpos$mutableblockpos)) {
                return Pair.of((Object)blockstate, (Object)blockpos$mutableblockpos.immutable());
            }
            ++i;
        }
        return null;
    }

    private static void renderTex(TextureAtlasSprite pTexture, PoseStack pPoseStack) {
        if (SmartAnimations.isActive()) {
            SmartAnimations.spriteRendered(pTexture);
        }
        RenderSystem.setShaderTexture(0, pTexture.atlas().location());
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        float f = 0.1f;
        float f1 = -1.0f;
        float f2 = 1.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -0.5f;
        float f6 = pTexture.getU0();
        float f7 = pTexture.getU1();
        float f8 = pTexture.getV0();
        float f9 = pTexture.getV1();
        Matrix4f matrix4f = pPoseStack.last().pose();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
        bufferbuilder.vertex(matrix4f, -1.0f, -1.0f, -0.5f).color(0.1f, 0.1f, 0.1f, 1.0f).uv(f7, f9).endVertex();
        bufferbuilder.vertex(matrix4f, 1.0f, -1.0f, -0.5f).color(0.1f, 0.1f, 0.1f, 1.0f).uv(f6, f9).endVertex();
        bufferbuilder.vertex(matrix4f, 1.0f, 1.0f, -0.5f).color(0.1f, 0.1f, 0.1f, 1.0f).uv(f6, f8).endVertex();
        bufferbuilder.vertex(matrix4f, -1.0f, 1.0f, -0.5f).color(0.1f, 0.1f, 0.1f, 1.0f).uv(f7, f8).endVertex();
        bufferbuilder.end();
        BufferUploader.end(bufferbuilder);
    }

    private static void renderWater(Minecraft pMinecraft, PoseStack pPoseStack) {
        if (!Config.isShaders() || Shaders.isUnderwaterOverlay()) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.enableTexture();
            RenderSystem.setShaderTexture(0, UNDERWATER_LOCATION);
            if (SmartAnimations.isActive()) {
                SmartAnimations.textureRendered(pMinecraft.getTextureManager().getTexture(UNDERWATER_LOCATION).getId());
            }
            BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
            float f = pMinecraft.player.getBrightness();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor(f, f, f, 0.1f);
            float f1 = 4.0f;
            float f2 = -1.0f;
            float f3 = 1.0f;
            float f4 = -1.0f;
            float f5 = 1.0f;
            float f6 = -0.5f;
            float f7 = -pMinecraft.player.getYRot() / 64.0f;
            float f8 = pMinecraft.player.getXRot() / 64.0f;
            Matrix4f matrix4f = pPoseStack.last().pose();
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferbuilder.vertex(matrix4f, -1.0f, -1.0f, -0.5f).uv(4.0f + f7, 4.0f + f8).endVertex();
            bufferbuilder.vertex(matrix4f, 1.0f, -1.0f, -0.5f).uv(0.0f + f7, 4.0f + f8).endVertex();
            bufferbuilder.vertex(matrix4f, 1.0f, 1.0f, -0.5f).uv(0.0f + f7, 0.0f + f8).endVertex();
            bufferbuilder.vertex(matrix4f, -1.0f, 1.0f, -0.5f).uv(4.0f + f7, 0.0f + f8).endVertex();
            bufferbuilder.end();
            BufferUploader.end(bufferbuilder);
            RenderSystem.disableBlend();
        }
    }

    private static void renderFire(Minecraft pMinecraft, PoseStack pPoseStack) {
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.depthFunc(519);
        RenderSystem.depthMask(false);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableTexture();
        TextureAtlasSprite textureatlassprite = ModelBakery.FIRE_1.sprite();
        if (SmartAnimations.isActive()) {
            SmartAnimations.spriteRendered(textureatlassprite);
        }
        RenderSystem.setShaderTexture(0, textureatlassprite.atlas().location());
        float f = textureatlassprite.getU0();
        float f1 = textureatlassprite.getU1();
        float f2 = (f + f1) / 2.0f;
        float f3 = textureatlassprite.getV0();
        float f4 = textureatlassprite.getV1();
        float f5 = (f3 + f4) / 2.0f;
        float f6 = textureatlassprite.uvShrinkRatio();
        float f7 = Mth.lerp(f6, f, f2);
        float f8 = Mth.lerp(f6, f1, f2);
        float f9 = Mth.lerp(f6, f3, f5);
        float f10 = Mth.lerp(f6, f4, f5);
        float f11 = 1.0f;
        int i = 0;
        while (i < 2) {
            pPoseStack.pushPose();
            float f12 = -0.5f;
            float f13 = 0.5f;
            float f14 = -0.5f;
            float f15 = 0.5f;
            float f16 = -0.5f;
            pPoseStack.translate((float)(-(i * 2 - 1)) * 0.24f, -0.3f, 0.0);
            pPoseStack.mulPose(Vector3f.YP.rotationDegrees((float)(i * 2 - 1) * 10.0f));
            Matrix4f matrix4f = pPoseStack.last().pose();
            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
            bufferbuilder.vertex(matrix4f, -0.5f, -0.5f, -0.5f).color(1.0f, 1.0f, 1.0f, 0.9f).uv(f8, f10).endVertex();
            bufferbuilder.vertex(matrix4f, 0.5f, -0.5f, -0.5f).color(1.0f, 1.0f, 1.0f, 0.9f).uv(f7, f10).endVertex();
            bufferbuilder.vertex(matrix4f, 0.5f, 0.5f, -0.5f).color(1.0f, 1.0f, 1.0f, 0.9f).uv(f7, f9).endVertex();
            bufferbuilder.vertex(matrix4f, -0.5f, 0.5f, -0.5f).color(1.0f, 1.0f, 1.0f, 0.9f).uv(f8, f9).endVertex();
            bufferbuilder.end();
            BufferUploader.end(bufferbuilder);
            pPoseStack.popPose();
            ++i;
        }
        RenderSystem.disableBlend();
        RenderSystem.depthMask(true);
        RenderSystem.depthFunc(515);
    }
}

