/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.optifine.Config;
import net.optifine.render.VboRegion;

public class ViewArea {
    protected final LevelRenderer levelRenderer;
    protected final Level level;
    protected int chunkGridSizeY;
    protected int chunkGridSizeX;
    protected int chunkGridSizeZ;
    public ChunkRenderDispatcher.RenderChunk[] chunks;
    private Map<ChunkPos, VboRegion[]> mapVboRegions = new HashMap<ChunkPos, VboRegion[]>();

    public ViewArea(ChunkRenderDispatcher pChunkRenderDispatcher, Level pLevel, int pViewDistance, LevelRenderer pLevelRenderer) {
        this.levelRenderer = pLevelRenderer;
        this.level = pLevel;
        this.setViewDistance(pViewDistance);
        this.createChunks(pChunkRenderDispatcher);
    }

    protected void createChunks(ChunkRenderDispatcher pRenderChunkFactory) {
        if (!Minecraft.getInstance().isSameThread()) {
            throw new IllegalStateException("createChunks called from wrong thread: " + Thread.currentThread().getName());
        }
        int i = this.chunkGridSizeX * this.chunkGridSizeY * this.chunkGridSizeZ;
        this.chunks = new ChunkRenderDispatcher.RenderChunk[i];
        int j = this.level.getMinBuildHeight();
        int k = 0;
        while (k < this.chunkGridSizeX) {
            int l = 0;
            while (l < this.chunkGridSizeY) {
                int i1 = 0;
                while (i1 < this.chunkGridSizeZ) {
                    int j1 = this.getChunkIndex(k, l, i1);
                    ChunkRenderDispatcher chunkRenderDispatcher = pRenderChunkFactory;
                    chunkRenderDispatcher.getClass();
                    this.chunks[j1] = chunkRenderDispatcher.new ChunkRenderDispatcher.RenderChunk(j1, k * 16, l * 16, i1 * 16);
                    this.chunks[j1].setOrigin(k * 16, l * 16 + j, i1 * 16);
                    if (Config.isVbo() && Config.isRenderRegions()) {
                        this.updateVboRegion(this.chunks[j1]);
                    }
                    ++i1;
                }
                ++l;
            }
            ++k;
        }
        int k1 = 0;
        while (k1 < this.chunks.length) {
            ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk1 = this.chunks[k1];
            int l1 = 0;
            while (l1 < Direction.VALUES.length) {
                Direction direction = Direction.VALUES[l1];
                BlockPos blockpos = chunkrenderdispatcher$renderchunk1.getRelativeOrigin(direction);
                ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.getRenderChunkAt(blockpos);
                chunkrenderdispatcher$renderchunk1.setRenderChunkNeighbour(direction, chunkrenderdispatcher$renderchunk);
                ++l1;
            }
            ++k1;
        }
    }

    public void releaseAllBuffers() {
        ChunkRenderDispatcher.RenderChunk[] renderChunkArray = this.chunks;
        int n = this.chunks.length;
        int n2 = 0;
        while (n2 < n) {
            ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = renderChunkArray[n2];
            chunkrenderdispatcher$renderchunk.releaseBuffers();
            ++n2;
        }
        this.deleteVboRegions();
    }

    private int getChunkIndex(int pX, int pY, int pZ) {
        return (pZ * this.chunkGridSizeY + pY) * this.chunkGridSizeX + pX;
    }

    protected void setViewDistance(int pRenderDistanceChunks) {
        int i;
        this.chunkGridSizeX = i = pRenderDistanceChunks * 2 + 1;
        this.chunkGridSizeY = this.level.getSectionsCount();
        this.chunkGridSizeZ = i;
    }

    public void repositionCamera(double pViewEntityX, double p_110852_) {
        int i = Mth.ceil(pViewEntityX);
        int j = Mth.ceil(p_110852_);
        int k = 0;
        while (k < this.chunkGridSizeX) {
            int l = this.chunkGridSizeX * 16;
            int i1 = i - 7 - l / 2;
            int j1 = i1 + Math.floorMod(k * 16 - i1, l);
            int k1 = 0;
            while (k1 < this.chunkGridSizeZ) {
                int l1 = this.chunkGridSizeZ * 16;
                int i2 = j - 7 - l1 / 2;
                int j2 = i2 + Math.floorMod(k1 * 16 - i2, l1);
                int k2 = 0;
                while (k2 < this.chunkGridSizeY) {
                    int l2 = this.level.getMinBuildHeight() + k2 * 16;
                    ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.chunks[this.getChunkIndex(k, k2, k1)];
                    BlockPos blockpos = chunkrenderdispatcher$renderchunk.getOrigin();
                    if (j1 != blockpos.getX() || l2 != blockpos.getY() || j2 != blockpos.getZ()) {
                        chunkrenderdispatcher$renderchunk.setOrigin(j1, l2, j2);
                    }
                    ++k2;
                }
                ++k1;
            }
            ++k;
        }
    }

    public void setDirty(int pSectionX, int pSectionY, int pSectionZ, boolean pReRenderOnMainThread) {
        int i = Math.floorMod(pSectionX, this.chunkGridSizeX);
        int j = Math.floorMod(pSectionY - this.level.getMinSection(), this.chunkGridSizeY);
        int k = Math.floorMod(pSectionZ, this.chunkGridSizeZ);
        ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.chunks[this.getChunkIndex(i, j, k)];
        chunkrenderdispatcher$renderchunk.setDirty(pReRenderOnMainThread);
    }

    @Nullable
    public ChunkRenderDispatcher.RenderChunk getRenderChunkAt(BlockPos pPos) {
        int i = pPos.getX() >> 4;
        int j = pPos.getY() - this.level.getMinBuildHeight() >> 4;
        int k = pPos.getZ() >> 4;
        if (j >= 0 && j < this.chunkGridSizeY) {
            i = Mth.positiveModulo(i, this.chunkGridSizeX);
            k = Mth.positiveModulo(k, this.chunkGridSizeZ);
            return this.chunks[this.getChunkIndex(i, j, k)];
        }
        return null;
    }

    private void updateVboRegion(ChunkRenderDispatcher.RenderChunk renderChunk) {
        BlockPos blockpos = renderChunk.getOrigin();
        int i = blockpos.getX() >> 8 << 8;
        int j = blockpos.getZ() >> 8 << 8;
        ChunkPos chunkpos = new ChunkPos(i, j);
        RenderType[] arendertype = RenderType.CHUNK_RENDER_TYPES;
        VboRegion[] avboregion = this.mapVboRegions.get(chunkpos);
        if (avboregion == null) {
            avboregion = new VboRegion[arendertype.length];
            int k = 0;
            while (k < arendertype.length) {
                if (!arendertype[k].isNeedsSorting()) {
                    avboregion[k] = new VboRegion(arendertype[k]);
                }
                ++k;
            }
            this.mapVboRegions.put(chunkpos, avboregion);
        }
        int l = 0;
        while (l < arendertype.length) {
            RenderType rendertype = arendertype[l];
            VboRegion vboregion = avboregion[l];
            renderChunk.getBuffer(rendertype).setVboRegion(vboregion);
            ++l;
        }
    }

    public void deleteVboRegions() {
        for (ChunkPos chunkpos : this.mapVboRegions.keySet()) {
            VboRegion[] avboregion = this.mapVboRegions.get(chunkpos);
            int i = 0;
            while (i < avboregion.length) {
                VboRegion vboregion = avboregion[i];
                if (vboregion != null) {
                    vboregion.deleteGlBuffers();
                }
                avboregion[i] = null;
                ++i;
            }
        }
        this.mapVboRegions.clear();
    }

    public int getHighestUsedChunkIndex(int chunkX, int minChunkIndex, int chunkZ) {
        chunkX = Mth.positiveModulo(chunkX, this.chunkGridSizeX);
        minChunkIndex = Mth.clamp(minChunkIndex, 0, this.chunkGridSizeY);
        chunkZ = Mth.positiveModulo(chunkZ, this.chunkGridSizeZ);
        int i = this.chunkGridSizeY - 1;
        while (i >= minChunkIndex) {
            ChunkRenderDispatcher.RenderChunk chunkrenderdispatcher$renderchunk = this.chunks[this.getChunkIndex(chunkX, i, chunkZ)];
            if (!chunkrenderdispatcher$renderchunk.getCompiledChunk().hasNoRenderableLayers()) {
                return i;
            }
            --i;
        }
        return -1;
    }
}

