/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockModelShaper {
    private final Map<BlockState, BakedModel> modelByStateCache = Maps.newIdentityHashMap();
    private final ModelManager modelManager;

    public BlockModelShaper(ModelManager pModelManager) {
        this.modelManager = pModelManager;
    }

    public TextureAtlasSprite getParticleIcon(BlockState pState) {
        return this.getBlockModel(pState).getParticleIcon();
    }

    public BakedModel getBlockModel(BlockState pState) {
        BakedModel bakedmodel = this.modelByStateCache.get(pState);
        if (bakedmodel == null) {
            bakedmodel = this.modelManager.getMissingModel();
        }
        return bakedmodel;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public void rebuildCache() {
        this.modelByStateCache.clear();
        for (Block block : Registry.BLOCK) {
            block.getStateDefinition().getPossibleStates().forEach(p_110898_ -> this.modelByStateCache.put((BlockState)p_110898_, this.modelManager.getModel(BlockModelShaper.stateToModelLocation(p_110898_))));
        }
    }

    public static ModelResourceLocation stateToModelLocation(BlockState pState) {
        return BlockModelShaper.stateToModelLocation(Registry.BLOCK.getKey(pState.getBlock()), pState);
    }

    public static ModelResourceLocation stateToModelLocation(ResourceLocation pLocation, BlockState pState) {
        return new ModelResourceLocation(pLocation, BlockModelShaper.statePropertiesToString(pState.getValues()));
    }

    public static String statePropertiesToString(Map<Property<?>, Comparable<?>> pPropertyValues) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<Property<?>, Comparable<?>> entry : pPropertyValues.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(',');
            }
            Property<?> property = entry.getKey();
            stringbuilder.append(property.getName());
            stringbuilder.append('=');
            stringbuilder.append(BlockModelShaper.getValue(property, entry.getValue()));
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getValue(Property<T> pProperty, Comparable<?> pValue) {
        return pProperty.getName(pValue);
    }
}

