/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.optifine.BetterSnow;
import net.optifine.BlockPosM;
import net.optifine.Config;
import net.optifine.CustomColors;
import net.optifine.EmissiveTextures;
import net.optifine.model.BlockModelCustomizer;
import net.optifine.model.ListQuadsOverlay;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import net.optifine.render.LightCacheOF;
import net.optifine.render.RenderEnv;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.SVertexBuilder;
import net.optifine.shaders.Shaders;
import net.optifine.util.BlockUtils;

public class ModelBlockRenderer {
    private static final int FACE_CUBIC = 0;
    private static final int FACE_PARTIAL = 1;
    static final Direction[] DIRECTIONS = Direction.values();
    private final BlockColors blockColors;
    private static final int CACHE_SIZE = 100;
    static final ThreadLocal<Cache> CACHE = ThreadLocal.withInitial(() -> new Cache());
    private static float aoLightValueOpaque = 0.2f;
    private static boolean separateAoLightValue = false;
    private static final LightCacheOF LIGHT_CACHE_OF = new LightCacheOF();
    private static final RenderType[] OVERLAY_LAYERS = new RenderType[]{RenderTypes.CUTOUT, RenderTypes.CUTOUT_MIPPED, RenderTypes.TRANSLUCENT};
    private boolean forgeModelData = Reflector.ForgeHooksClient.exists();

    public ModelBlockRenderer(BlockColors pBlockColors) {
        this.blockColors = pBlockColors;
    }

    public boolean tesselateBlock(BlockAndTintGetter pLevel, BakedModel pModel, BlockState pState, BlockPos pPos, PoseStack pPoseStack, VertexConsumer pConsumer, boolean pCheckSides, Random pRandom, long pSeed, int p_111057_) {
        return this.tesselateBlock(pLevel, pModel, pState, pPos, pPoseStack, pConsumer, pCheckSides, pRandom, pSeed, p_111057_, EmptyModelData.INSTANCE);
    }

    public boolean tesselateBlock(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        boolean flag;
        boolean bl = flag = Minecraft.useAmbientOcclusion() && ReflectorForge.getLightEmission(stateIn, worldIn, posIn) == 0 && modelIn.useAmbientOcclusion();
        if (this.forgeModelData) {
            modelData = modelIn.getModelData(worldIn, posIn, stateIn, modelData);
        }
        Vec3 vec3 = stateIn.getOffset(worldIn, posIn);
        matrixIn.translate(vec3.x, vec3.y, vec3.z);
        try {
            boolean flag1;
            if (Config.isShaders()) {
                SVertexBuilder.pushEntity(stateIn, buffer);
            }
            if (!Config.isAlternateBlocks()) {
                rand = 0L;
            }
            RenderEnv renderenv = buffer.getRenderEnv(stateIn, posIn);
            modelIn = BlockModelCustomizer.getRenderModel(modelIn, stateIn, renderenv);
            boolean bl2 = flag1 = flag ? this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData) : this.renderModelFlat(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData);
            if (flag1) {
                this.renderOverlayModels(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, combinedOverlayIn, checkSides, randomIn, rand, renderenv, flag, vec3);
            }
            if (Config.isShaders()) {
                SVertexBuilder.popEntity(buffer);
            }
            return flag1;
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.forThrowable(throwable1, "Tesselating block model");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block model being tesselated");
            CrashReportCategory.populateBlockDetails(crashreportcategory, worldIn, posIn, stateIn);
            crashreportcategory.setDetail("Using AO", flag);
            throw new ReportedException(crashreport);
        }
    }

    public boolean tesselateWithAO(BlockAndTintGetter pLevel, BakedModel pModel, BlockState pState, BlockPos pPos, PoseStack pPoseStack, VertexConsumer pConsumer, boolean pCheckSides, Random pRandom, long pSeed, int p_111088_) {
        return this.renderModelSmooth(pLevel, pModel, pState, pPos, pPoseStack, pConsumer, pCheckSides, pRandom, pSeed, p_111088_, EmptyModelData.INSTANCE);
    }

    public boolean renderModelSmooth(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        List<BakedQuad> list1;
        boolean flag = false;
        RenderEnv renderenv = buffer.getRenderEnv(stateIn, posIn);
        RenderType rendertype = buffer.getRenderType();
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (!checkSides || BlockUtils.shouldSideBeRendered(stateIn, worldIn, posIn, direction, renderenv)) {
                randomIn.setSeed(rand);
                List<BakedQuad> list = this.forgeModelData ? modelIn.getQuads(stateIn, direction, randomIn, modelData) : modelIn.getQuads(stateIn, direction, randomIn);
                list = BlockModelCustomizer.getRenderQuads(list, worldIn, stateIn, posIn, direction, rendertype, rand, renderenv);
                if (!list.isEmpty()) {
                    this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStackIn, buffer, list, combinedOverlayIn, renderenv);
                    flag = true;
                }
            }
            ++n2;
        }
        randomIn.setSeed(rand);
        List<BakedQuad> list = list1 = this.forgeModelData ? modelIn.getQuads(stateIn, null, randomIn, modelData) : modelIn.getQuads(stateIn, null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads(list1, worldIn, stateIn, posIn, null, rendertype, rand, renderenv);
            this.renderQuadsSmooth(worldIn, stateIn, posIn, matrixStackIn, buffer, list1, combinedOverlayIn, renderenv);
            flag = true;
        }
        return flag;
    }

    public boolean tesselateWithoutAO(BlockAndTintGetter pLevel, BakedModel pModel, BlockState pState, BlockPos pPos, PoseStack pPoseStack, VertexConsumer pConsumer, boolean pCheckSides, Random pRandom, long pSeed, int p_111100_) {
        return this.renderModelFlat(pLevel, pModel, pState, pPos, pPoseStack, pConsumer, pCheckSides, pRandom, pSeed, p_111100_, EmptyModelData.INSTANCE);
    }

    public boolean renderModelFlat(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        List<BakedQuad> list1;
        boolean flag = false;
        RenderEnv renderenv = buffer.getRenderEnv(stateIn, posIn);
        RenderType rendertype = buffer.getRenderType();
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            if (!checkSides || BlockUtils.shouldSideBeRendered(stateIn, worldIn, posIn, direction, renderenv)) {
                randomIn.setSeed(rand);
                List<BakedQuad> list = this.forgeModelData ? modelIn.getQuads(stateIn, direction, randomIn, modelData) : modelIn.getQuads(stateIn, direction, randomIn);
                list = BlockModelCustomizer.getRenderQuads(list, worldIn, stateIn, posIn, direction, rendertype, rand, renderenv);
                if (!list.isEmpty()) {
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = renderenv.getRenderMutableBlockPos();
                    blockpos$mutableblockpos.setWithOffset((Vec3i)posIn, direction);
                    int i = LevelRenderer.getLightColor(worldIn, stateIn, blockpos$mutableblockpos);
                    this.renderQuadsFlat(worldIn, stateIn, posIn, i, combinedOverlayIn, false, matrixStackIn, buffer, list, renderenv);
                    flag = true;
                }
            }
            ++n2;
        }
        randomIn.setSeed(rand);
        List<BakedQuad> list = list1 = this.forgeModelData ? modelIn.getQuads(stateIn, null, randomIn, modelData) : modelIn.getQuads(stateIn, null, randomIn);
        if (!list1.isEmpty()) {
            list1 = BlockModelCustomizer.getRenderQuads(list1, worldIn, stateIn, posIn, null, rendertype, rand, renderenv);
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, combinedOverlayIn, true, matrixStackIn, buffer, list1, renderenv);
            flag = true;
        }
        return flag;
    }

    private void renderQuadsSmooth(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, List<BakedQuad> list, int combinedOverlayIn, RenderEnv renderEnv) {
        float[] afloat = renderEnv.getQuadBounds();
        BitSet bitset = renderEnv.getBoundsFlags();
        AmbientOcclusionFace modelblockrenderer$ambientocclusionface = renderEnv.getAoFace();
        int i = list.size();
        int j = 0;
        while (j < i) {
            BakedQuad bakedquad = list.get(j);
            this.a(blockAccessIn, stateIn, posIn, bakedquad.getVertices(), bakedquad.getDirection(), afloat, bitset);
            modelblockrenderer$ambientocclusionface.a(blockAccessIn, stateIn, posIn, bakedquad.getDirection(), afloat, bitset, bakedquad.isShade());
            if (bakedquad.getSprite().isSpriteEmissive) {
                modelblockrenderer$ambientocclusionface.setMaxBlockLight();
            }
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.last(), bakedquad, modelblockrenderer$ambientocclusionface.brightness[0], modelblockrenderer$ambientocclusionface.brightness[1], modelblockrenderer$ambientocclusionface.brightness[2], modelblockrenderer$ambientocclusionface.brightness[3], modelblockrenderer$ambientocclusionface.lightmap[0], modelblockrenderer$ambientocclusionface.lightmap[1], modelblockrenderer$ambientocclusionface.lightmap[2], modelblockrenderer$ambientocclusionface.lightmap[3], combinedOverlayIn, renderEnv);
            ++j;
        }
    }

    private void renderQuadSmooth(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, VertexConsumer buffer, PoseStack.Pose matrixEntry, BakedQuad quadIn, float colorMul0, float colorMul1, float colorMul2, float colorMul3, int brightness0, int brightness1, int brightness2, int brightness3, int combinedOverlayIn, RenderEnv renderEnv) {
        float f2;
        float f1;
        float f;
        int i = CustomColors.getColorMultiplier(quadIn, stateIn, blockAccessIn, posIn, renderEnv);
        if (!quadIn.isTinted() && i == -1) {
            f = 1.0f;
            f1 = 1.0f;
            f2 = 1.0f;
        } else {
            int j = i != -1 ? i : this.blockColors.getColor(stateIn, blockAccessIn, posIn, quadIn.getTintIndex());
            f = (float)(j >> 16 & 0xFF) / 255.0f;
            f1 = (float)(j >> 8 & 0xFF) / 255.0f;
            f2 = (float)(j & 0xFF) / 255.0f;
        }
        buffer.a(matrixEntry, quadIn, buffer.getTempFloat4(colorMul0, colorMul1, colorMul2, colorMul3), f, f1, f2, buffer.getTempInt4(brightness0, brightness1, brightness2, brightness3), combinedOverlayIn, true);
    }

    private void a(BlockAndTintGetter p_111040_, BlockState p_111041_, BlockPos p_111042_, int[] p_111043_, Direction p_111044_, @Nullable float[] p_111045_, BitSet p_111046_) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        int i = p_111043_.length / 4;
        int j = 0;
        while (j < 4) {
            float f6 = Float.intBitsToFloat(p_111043_[j * i]);
            float f7 = Float.intBitsToFloat(p_111043_[j * i + 1]);
            float f8 = Float.intBitsToFloat(p_111043_[j * i + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
            ++j;
        }
        if (p_111045_ != null) {
            p_111045_[Direction.WEST.get3DDataValue()] = f;
            p_111045_[Direction.EAST.get3DDataValue()] = f3;
            p_111045_[Direction.DOWN.get3DDataValue()] = f1;
            p_111045_[Direction.UP.get3DDataValue()] = f4;
            p_111045_[Direction.NORTH.get3DDataValue()] = f2;
            p_111045_[Direction.SOUTH.get3DDataValue()] = f5;
            int k = DIRECTIONS.length;
            p_111045_[Direction.WEST.get3DDataValue() + k] = 1.0f - f;
            p_111045_[Direction.EAST.get3DDataValue() + k] = 1.0f - f3;
            p_111045_[Direction.DOWN.get3DDataValue() + k] = 1.0f - f1;
            p_111045_[Direction.UP.get3DDataValue() + k] = 1.0f - f4;
            p_111045_[Direction.NORTH.get3DDataValue() + k] = 1.0f - f2;
            p_111045_[Direction.SOUTH.get3DDataValue() + k] = 1.0f - f5;
        }
        float f9 = 1.0E-4f;
        float f10 = 0.9999f;
        switch (p_111044_) {
            case DOWN: {
                p_111046_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_111046_.set(0, f1 == f4 && (f1 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case UP: {
                p_111046_.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                p_111046_.set(0, f1 == f4 && (f4 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case NORTH: {
                p_111046_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_111046_.set(0, f2 == f5 && (f2 < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case SOUTH: {
                p_111046_.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                p_111046_.set(0, f2 == f5 && (f5 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case WEST: {
                p_111046_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_111046_.set(0, f == f3 && (f < 1.0E-4f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
                break;
            }
            case EAST: {
                p_111046_.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                p_111046_.set(0, f == f3 && (f3 > 0.9999f || p_111041_.isCollisionShapeFullBlock(p_111040_, p_111042_)));
            }
        }
    }

    private void renderQuadsFlat(BlockAndTintGetter blockAccessIn, BlockState stateIn, BlockPos posIn, int brightnessIn, int combinedOverlayIn, boolean ownBrightness, PoseStack matrixStackIn, VertexConsumer buffer, List<BakedQuad> list, RenderEnv renderEnv) {
        BitSet bitset = renderEnv.getBoundsFlags();
        int i = list.size();
        int j = 0;
        while (j < i) {
            BakedQuad bakedquad = list.get(j);
            if (ownBrightness) {
                this.a(blockAccessIn, stateIn, posIn, bakedquad.getVertices(), bakedquad.getDirection(), null, bitset);
                BlockPos blockpos = bitset.get(0) ? posIn.relative(bakedquad.getDirection()) : posIn;
                brightnessIn = LevelRenderer.getLightColor(blockAccessIn, stateIn, blockpos);
            }
            if (bakedquad.getSprite().isSpriteEmissive) {
                brightnessIn = LightTexture.MAX_BRIGHTNESS;
            }
            float f = blockAccessIn.getShade(bakedquad.getDirection(), bakedquad.isShade());
            this.renderQuadSmooth(blockAccessIn, stateIn, posIn, buffer, matrixStackIn.last(), bakedquad, f, f, f, f, brightnessIn, brightnessIn, brightnessIn, brightnessIn, combinedOverlayIn, renderEnv);
            ++j;
        }
    }

    public void renderModel(PoseStack.Pose pPose, VertexConsumer pConsumer, @Nullable BlockState pState, BakedModel pModel, float pRed, float pGreen, float pBlue, int pPackedLight, int pPackedOverlay) {
        this.renderModel(pPose, pConsumer, pState, pModel, pRed, pGreen, pBlue, pPackedLight, pPackedOverlay, EmptyModelData.INSTANCE);
    }

    public void renderModel(PoseStack.Pose matrixEntry, VertexConsumer buffer, @Nullable BlockState state, BakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        Random random = new Random();
        long i = 42L;
        Direction[] directionArray = DIRECTIONS;
        int n = DIRECTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Direction direction = directionArray[n2];
            random.setSeed(42L);
            if (this.forgeModelData) {
                ModelBlockRenderer.renderQuadList(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, direction, random, modelData), combinedLightIn, combinedOverlayIn);
            } else {
                ModelBlockRenderer.renderQuadList(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, direction, random), combinedLightIn, combinedOverlayIn);
            }
            ++n2;
        }
        random.setSeed(42L);
        if (this.forgeModelData) {
            ModelBlockRenderer.renderQuadList(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, null, random, modelData), combinedLightIn, combinedOverlayIn);
        } else {
            ModelBlockRenderer.renderQuadList(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, null, random), combinedLightIn, combinedOverlayIn);
        }
    }

    private static void renderQuadList(PoseStack.Pose pPose, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, List<BakedQuad> pQuads, int pPackedLight, int pPackedOverlay) {
        boolean flag = EmissiveTextures.isActive();
        Iterator<BakedQuad> iterator = pQuads.iterator();
        while (iterator.hasNext()) {
            float f2;
            float f1;
            float f;
            BakedQuad bakedquad = iterator.next();
            if (flag && (bakedquad = EmissiveTextures.getEmissiveQuad(bakedquad)) == null) continue;
            if (bakedquad.isTinted()) {
                f = Mth.clamp(pRed, 0.0f, 1.0f);
                f1 = Mth.clamp(pGreen, 0.0f, 1.0f);
                f2 = Mth.clamp(pBlue, 0.0f, 1.0f);
            } else {
                f = 1.0f;
                f1 = 1.0f;
                f2 = 1.0f;
            }
            pConsumer.putBulkData(pPose, bakedquad, f, f1, f2, pPackedLight, pPackedOverlay);
        }
        return;
    }

    public static void enableCaching() {
        CACHE.get().enable();
    }

    public static void clearCache() {
        CACHE.get().disable();
    }

    public static float fixAoLightValue(float val) {
        return val == 0.2f ? aoLightValueOpaque : val;
    }

    public static void updateAoLightValue() {
        aoLightValueOpaque = 1.0f - Config.getAmbientOcclusionLevel() * 0.8f;
        separateAoLightValue = Config.isShaders() && Shaders.isSeparateAo();
    }

    public static boolean isSeparateAoLightValue() {
        return separateAoLightValue;
    }

    private void renderOverlayModels(BlockAndTintGetter worldIn, BakedModel modelIn, BlockState stateIn, BlockPos posIn, PoseStack matrixStackIn, VertexConsumer buffer, int combinedOverlayIn, boolean checkSides, Random random, long rand, RenderEnv renderEnv, boolean smooth, Vec3 renderOffset) {
        if (renderEnv.isOverlaysRendered()) {
            int i = 0;
            while (i < OVERLAY_LAYERS.length) {
                RenderType rendertype = OVERLAY_LAYERS[i];
                ListQuadsOverlay listquadsoverlay = renderEnv.getListQuadsOverlay(rendertype);
                if (listquadsoverlay.size() > 0) {
                    ChunkBufferBuilderPack chunkbufferbuilderpack = renderEnv.getRegionRenderCacheBuilder();
                    if (chunkbufferbuilderpack != null) {
                        BufferBuilder bufferbuilder = chunkbufferbuilderpack.builder(rendertype);
                        if (!bufferbuilder.building()) {
                            bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                        }
                        int j = 0;
                        while (j < listquadsoverlay.size()) {
                            BakedQuad bakedquad = listquadsoverlay.getQuad(j);
                            List<BakedQuad> list = listquadsoverlay.getListQuadsSingle(bakedquad);
                            BlockState blockstate = listquadsoverlay.getBlockState(j);
                            if (bakedquad.getQuadEmissive() != null) {
                                listquadsoverlay.addQuad(bakedquad.getQuadEmissive(), blockstate);
                            }
                            renderEnv.reset(blockstate, posIn);
                            if (smooth) {
                                this.renderQuadsSmooth(worldIn, blockstate, posIn, matrixStackIn, bufferbuilder, list, combinedOverlayIn, renderEnv);
                            } else {
                                int k = LevelRenderer.getLightColor(worldIn, blockstate, posIn.relative(bakedquad.getDirection()));
                                this.renderQuadsFlat(worldIn, blockstate, posIn, k, combinedOverlayIn, false, matrixStackIn, bufferbuilder, list, renderEnv);
                            }
                            ++j;
                        }
                    }
                    listquadsoverlay.clear();
                }
                ++i;
            }
        }
        if (Config.isBetterSnow() && !renderEnv.isBreakingAnimation() && BetterSnow.shouldRender(worldIn, stateIn, posIn)) {
            BakedModel bakedmodel = BetterSnow.getModelSnowLayer();
            BlockState blockstate1 = BetterSnow.getStateSnowLayer();
            matrixStackIn.translate(-renderOffset.x, -renderOffset.y, -renderOffset.z);
            this.tesselateBlock(worldIn, bakedmodel, blockstate1, posIn, matrixStackIn, buffer, checkSides, random, rand, combinedOverlayIn);
        }
    }

    protected static enum AdjacencyInfo {
        DOWN(new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}, 0.5f, true, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.WEST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_WEST, SizeInfo.NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_EAST, SizeInfo.SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.EAST, SizeInfo.SOUTH}),
        UP(new Direction[]{Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}, 1.0f, true, new SizeInfo[]{SizeInfo.EAST, SizeInfo.SOUTH, SizeInfo.EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_EAST, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.EAST, SizeInfo.NORTH, SizeInfo.EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_EAST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.NORTH, SizeInfo.WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_WEST, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.WEST, SizeInfo.SOUTH, SizeInfo.WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_WEST, SizeInfo.SOUTH}),
        NORTH(new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST}),
        SOUTH(new Direction[]{Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP}, 0.8f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.FLIP_WEST, SizeInfo.FLIP_UP, SizeInfo.WEST, SizeInfo.UP, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_WEST, SizeInfo.FLIP_DOWN, SizeInfo.WEST, SizeInfo.DOWN, SizeInfo.WEST}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_EAST, SizeInfo.FLIP_DOWN, SizeInfo.EAST, SizeInfo.DOWN, SizeInfo.EAST}, new SizeInfo[]{SizeInfo.UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.FLIP_EAST, SizeInfo.FLIP_UP, SizeInfo.EAST, SizeInfo.UP, SizeInfo.EAST}),
        WEST(new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.UP, SizeInfo.SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_UP, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.UP, SizeInfo.NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.FLIP_DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.DOWN, SizeInfo.SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.SOUTH}),
        EAST(new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH}, 0.6f, true, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.SOUTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.FLIP_SOUTH, SizeInfo.DOWN, SizeInfo.SOUTH}, new SizeInfo[]{SizeInfo.FLIP_DOWN, SizeInfo.NORTH, SizeInfo.FLIP_DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.FLIP_NORTH, SizeInfo.DOWN, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.NORTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.FLIP_NORTH, SizeInfo.UP, SizeInfo.NORTH}, new SizeInfo[]{SizeInfo.FLIP_UP, SizeInfo.SOUTH, SizeInfo.FLIP_UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.FLIP_SOUTH, SizeInfo.UP, SizeInfo.SOUTH});

        final Direction[] corners;
        final boolean doNonCubicWeight;
        final SizeInfo[] vert0Weights;
        final SizeInfo[] vert1Weights;
        final SizeInfo[] vert2Weights;
        final SizeInfo[] vert3Weights;
        private static final AdjacencyInfo[] BY_FACING;

        static {
            BY_FACING = Util.make(new AdjacencyInfo[6], infoIn -> {
                infoIn[Direction.DOWN.get3DDataValue()] = DOWN;
                infoIn[Direction.UP.get3DDataValue()] = UP;
                infoIn[Direction.NORTH.get3DDataValue()] = NORTH;
                infoIn[Direction.SOUTH.get3DDataValue()] = SOUTH;
                infoIn[Direction.WEST.get3DDataValue()] = WEST;
                infoIn[Direction.EAST.get3DDataValue()] = EAST;
            });
        }

        private AdjacencyInfo(Direction[] p_111122_, float p_111123_, boolean p_111124_, SizeInfo[] p_111125_, SizeInfo[] p_111126_, SizeInfo[] p_111127_, SizeInfo[] p_111128_) {
            this.corners = p_111122_;
            this.doNonCubicWeight = p_111124_;
            this.vert0Weights = p_111125_;
            this.vert1Weights = p_111126_;
            this.vert2Weights = p_111127_;
            this.vert3Weights = p_111128_;
        }

        public static AdjacencyInfo fromFacing(Direction pFacing) {
            return BY_FACING[pFacing.get3DDataValue()];
        }
    }

    public static class AmbientOcclusionFace {
        final float[] brightness = new float[4];
        final int[] lightmap = new int[4];
        private BlockPosM blockPos = new BlockPosM();

        public AmbientOcclusionFace() {
            this(null);
        }

        public AmbientOcclusionFace(ModelBlockRenderer p_111152_) {
        }

        public void setMaxBlockLight() {
            int i;
            this.lightmap[0] = i = LightTexture.MAX_BRIGHTNESS;
            this.lightmap[1] = i;
            this.lightmap[2] = i;
            this.lightmap[3] = i;
            this.brightness[0] = 1.0f;
            this.brightness[1] = 1.0f;
            this.brightness[2] = 1.0f;
            this.brightness[3] = 1.0f;
        }

        public void a(BlockAndTintGetter p_111168_, BlockState p_111169_, BlockPos p_111170_, Direction p_111171_, float[] p_111172_, BitSet p_111173_, boolean p_111174_) {
            int l1;
            float f28;
            int k1;
            float f27;
            int j1;
            float f26;
            int i1;
            float f4;
            boolean flag3;
            BlockPos blockpos = p_111173_.get(0) ? p_111170_.relative(p_111171_) : p_111170_;
            AdjacencyInfo modelblockrenderer$adjacencyinfo = AdjacencyInfo.fromFacing(p_111171_);
            BlockPosM blockposm = this.blockPos;
            LightCacheOF lightcacheof = LIGHT_CACHE_OF;
            blockposm.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.corners[0]);
            BlockState blockstate = p_111168_.getBlockState(blockposm);
            int i = LightCacheOF.getPackedLight(blockstate, p_111168_, blockposm);
            float f = LightCacheOF.getBrightness(blockstate, p_111168_, blockposm);
            blockposm.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.corners[1]);
            BlockState blockstate1 = p_111168_.getBlockState(blockposm);
            int j = LightCacheOF.getPackedLight(blockstate1, p_111168_, blockposm);
            float f1 = LightCacheOF.getBrightness(blockstate1, p_111168_, blockposm);
            blockposm.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.corners[2]);
            BlockState blockstate2 = p_111168_.getBlockState(blockposm);
            int k = LightCacheOF.getPackedLight(blockstate2, p_111168_, blockposm);
            float f2 = LightCacheOF.getBrightness(blockstate2, p_111168_, blockposm);
            blockposm.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.corners[3]);
            BlockState blockstate3 = p_111168_.getBlockState(blockposm);
            int l = LightCacheOF.getPackedLight(blockstate3, p_111168_, blockposm);
            float f3 = LightCacheOF.getBrightness(blockstate3, p_111168_, blockposm);
            boolean flag = !blockstate.isViewBlocking(p_111168_, blockposm) || blockstate.getLightBlock(p_111168_, blockposm) == 0;
            boolean flag1 = !blockstate1.isViewBlocking(p_111168_, blockposm) || blockstate1.getLightBlock(p_111168_, blockposm) == 0;
            boolean flag2 = !blockstate2.isViewBlocking(p_111168_, blockposm) || blockstate2.getLightBlock(p_111168_, blockposm) == 0;
            boolean bl = flag3 = !blockstate3.isViewBlocking(p_111168_, blockposm) || blockstate3.getLightBlock(p_111168_, blockposm) == 0;
            if (!flag2 && !flag) {
                f4 = (f + f2) / 2.0f;
                i1 = AmbientOcclusionFace.blend(i, k, 0, 0);
            } else {
                blockposm.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.corners[0], modelblockrenderer$adjacencyinfo.corners[2]);
                BlockState blockstate4 = p_111168_.getBlockState(blockposm);
                f4 = LightCacheOF.getBrightness(blockstate4, p_111168_, blockposm);
                i1 = LightCacheOF.getPackedLight(blockstate4, p_111168_, blockposm);
            }
            if (!flag3 && !flag) {
                f26 = (f + f3) / 2.0f;
                j1 = AmbientOcclusionFace.blend(i, l, 0, 0);
            } else {
                blockposm.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.corners[0], modelblockrenderer$adjacencyinfo.corners[3]);
                BlockState blockstate5 = p_111168_.getBlockState(blockposm);
                f26 = LightCacheOF.getBrightness(blockstate5, p_111168_, blockposm);
                j1 = LightCacheOF.getPackedLight(blockstate5, p_111168_, blockposm);
            }
            if (!flag2 && !flag1) {
                f27 = (f1 + f2) / 2.0f;
                k1 = AmbientOcclusionFace.blend(j, k, 0, 0);
            } else {
                blockposm.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.corners[1], modelblockrenderer$adjacencyinfo.corners[2]);
                BlockState blockstate6 = p_111168_.getBlockState(blockposm);
                f27 = LightCacheOF.getBrightness(blockstate6, p_111168_, blockposm);
                k1 = LightCacheOF.getPackedLight(blockstate6, p_111168_, blockposm);
            }
            if (!flag3 && !flag1) {
                f28 = (f1 + f3) / 2.0f;
                l1 = AmbientOcclusionFace.blend(j, l, 0, 0);
            } else {
                blockposm.setPosOffset(blockpos, modelblockrenderer$adjacencyinfo.corners[1], modelblockrenderer$adjacencyinfo.corners[3]);
                BlockState blockstate7 = p_111168_.getBlockState(blockposm);
                f28 = LightCacheOF.getBrightness(blockstate7, p_111168_, blockposm);
                l1 = LightCacheOF.getPackedLight(blockstate7, p_111168_, blockposm);
            }
            int i3 = LightCacheOF.getPackedLight(p_111169_, p_111168_, p_111170_);
            blockposm.setPosOffset(p_111170_, p_111171_);
            BlockState blockstate8 = p_111168_.getBlockState(blockposm);
            if (p_111173_.get(0) || !blockstate8.isSolidRender(p_111168_, blockposm)) {
                i3 = LightCacheOF.getPackedLight(blockstate8, p_111168_, blockposm);
            }
            float f5 = p_111173_.get(0) ? LightCacheOF.getBrightness(p_111168_.getBlockState(blockpos), p_111168_, blockpos) : LightCacheOF.getBrightness(p_111168_.getBlockState(p_111170_), p_111168_, p_111170_);
            AmbientVertexRemap modelblockrenderer$ambientvertexremap = AmbientVertexRemap.fromFacing(p_111171_);
            if (p_111173_.get(1) && modelblockrenderer$adjacencyinfo.doNonCubicWeight) {
                float f29 = (f3 + f + f26 + f5) * 0.25f;
                float f31 = (f2 + f + f4 + f5) * 0.25f;
                float f32 = (f2 + f1 + f27 + f5) * 0.25f;
                float f33 = (f3 + f1 + f28 + f5) * 0.25f;
                float f10 = p_111172_[modelblockrenderer$adjacencyinfo.vert0Weights[0].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert0Weights[1].shape];
                float f11 = p_111172_[modelblockrenderer$adjacencyinfo.vert0Weights[2].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert0Weights[3].shape];
                float f12 = p_111172_[modelblockrenderer$adjacencyinfo.vert0Weights[4].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert0Weights[5].shape];
                float f13 = p_111172_[modelblockrenderer$adjacencyinfo.vert0Weights[6].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert0Weights[7].shape];
                float f14 = p_111172_[modelblockrenderer$adjacencyinfo.vert1Weights[0].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert1Weights[1].shape];
                float f15 = p_111172_[modelblockrenderer$adjacencyinfo.vert1Weights[2].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert1Weights[3].shape];
                float f16 = p_111172_[modelblockrenderer$adjacencyinfo.vert1Weights[4].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert1Weights[5].shape];
                float f17 = p_111172_[modelblockrenderer$adjacencyinfo.vert1Weights[6].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert1Weights[7].shape];
                float f18 = p_111172_[modelblockrenderer$adjacencyinfo.vert2Weights[0].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert2Weights[1].shape];
                float f19 = p_111172_[modelblockrenderer$adjacencyinfo.vert2Weights[2].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert2Weights[3].shape];
                float f20 = p_111172_[modelblockrenderer$adjacencyinfo.vert2Weights[4].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert2Weights[5].shape];
                float f21 = p_111172_[modelblockrenderer$adjacencyinfo.vert2Weights[6].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert2Weights[7].shape];
                float f22 = p_111172_[modelblockrenderer$adjacencyinfo.vert3Weights[0].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert3Weights[1].shape];
                float f23 = p_111172_[modelblockrenderer$adjacencyinfo.vert3Weights[2].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert3Weights[3].shape];
                float f24 = p_111172_[modelblockrenderer$adjacencyinfo.vert3Weights[4].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert3Weights[5].shape];
                float f25 = p_111172_[modelblockrenderer$adjacencyinfo.vert3Weights[6].shape] * p_111172_[modelblockrenderer$adjacencyinfo.vert3Weights[7].shape];
                this.brightness[modelblockrenderer$ambientvertexremap.vert0] = f29 * f10 + f31 * f11 + f32 * f12 + f33 * f13;
                this.brightness[modelblockrenderer$ambientvertexremap.vert1] = f29 * f14 + f31 * f15 + f32 * f16 + f33 * f17;
                this.brightness[modelblockrenderer$ambientvertexremap.vert2] = f29 * f18 + f31 * f19 + f32 * f20 + f33 * f21;
                this.brightness[modelblockrenderer$ambientvertexremap.vert3] = f29 * f22 + f31 * f23 + f32 * f24 + f33 * f25;
                int i2 = AmbientOcclusionFace.blend(l, i, j1, i3);
                int j2 = AmbientOcclusionFace.blend(k, i, i1, i3);
                int k2 = AmbientOcclusionFace.blend(k, j, k1, i3);
                int l2 = AmbientOcclusionFace.blend(l, j, l1, i3);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert0] = this.blend(i2, j2, k2, l2, f10, f11, f12, f13);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert1] = this.blend(i2, j2, k2, l2, f14, f15, f16, f17);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert2] = this.blend(i2, j2, k2, l2, f18, f19, f20, f21);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert3] = this.blend(i2, j2, k2, l2, f22, f23, f24, f25);
            } else {
                float f6 = (f3 + f + f26 + f5) * 0.25f;
                float f7 = (f2 + f + f4 + f5) * 0.25f;
                float f8 = (f2 + f1 + f27 + f5) * 0.25f;
                float f9 = (f3 + f1 + f28 + f5) * 0.25f;
                this.lightmap[modelblockrenderer$ambientvertexremap.vert0] = AmbientOcclusionFace.blend(l, i, j1, i3);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert1] = AmbientOcclusionFace.blend(k, i, i1, i3);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert2] = AmbientOcclusionFace.blend(k, j, k1, i3);
                this.lightmap[modelblockrenderer$ambientvertexremap.vert3] = AmbientOcclusionFace.blend(l, j, l1, i3);
                this.brightness[modelblockrenderer$ambientvertexremap.vert0] = f6;
                this.brightness[modelblockrenderer$ambientvertexremap.vert1] = f7;
                this.brightness[modelblockrenderer$ambientvertexremap.vert2] = f8;
                this.brightness[modelblockrenderer$ambientvertexremap.vert3] = f9;
            }
            float f30 = p_111168_.getShade(p_111171_, p_111174_);
            int j3 = 0;
            while (j3 < this.brightness.length) {
                int n = j3++;
                this.brightness[n] = this.brightness[n] * f30;
            }
        }

        public static int blend(int pLightColor0, int pLightColor1, int pLightColor2, int pLightColor3) {
            int i = pLightColor0 + pLightColor1 + pLightColor2 + pLightColor3;
            int j = 4;
            if (pLightColor0 == 0) {
                --j;
            }
            if (pLightColor1 == 0) {
                --j;
            }
            if (pLightColor2 == 0) {
                --j;
            }
            if (pLightColor3 == 0) {
                --j;
            }
            switch (j) {
                case 0: 
                case 1: {
                    return i;
                }
                case 2: {
                    return i >> 1 & 0xFF00FF;
                }
                case 3: {
                    return i / 3 & 0xFF0000 | (i & 0xFFFF) / 3;
                }
            }
            return i >> 2 & 0xFF00FF;
        }

        private int blend(int pBrightness0, int pBrightness1, int pBrightness2, int pBrightness3, float pWeight0, float pWeight1, float pWeight2, float pWeight3) {
            int i = (int)((float)(pBrightness0 >> 16 & 0xFF) * pWeight0 + (float)(pBrightness1 >> 16 & 0xFF) * pWeight1 + (float)(pBrightness2 >> 16 & 0xFF) * pWeight2 + (float)(pBrightness3 >> 16 & 0xFF) * pWeight3) & 0xFF;
            int j = (int)((float)(pBrightness0 & 0xFF) * pWeight0 + (float)(pBrightness1 & 0xFF) * pWeight1 + (float)(pBrightness2 & 0xFF) * pWeight2 + (float)(pBrightness3 & 0xFF) * pWeight3) & 0xFF;
            return i << 16 | j;
        }
    }

    static enum AmbientVertexRemap {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        final int vert0;
        final int vert1;
        final int vert2;
        final int vert3;
        private static final AmbientVertexRemap[] BY_FACING;

        static {
            BY_FACING = Util.make(new AmbientVertexRemap[6], remapIn -> {
                remapIn[Direction.DOWN.get3DDataValue()] = DOWN;
                remapIn[Direction.UP.get3DDataValue()] = UP;
                remapIn[Direction.NORTH.get3DDataValue()] = NORTH;
                remapIn[Direction.SOUTH.get3DDataValue()] = SOUTH;
                remapIn[Direction.WEST.get3DDataValue()] = WEST;
                remapIn[Direction.EAST.get3DDataValue()] = EAST;
            });
        }

        private AmbientVertexRemap(int p_111195_, int p_111196_, int p_111197_, int p_111198_) {
            this.vert0 = p_111195_;
            this.vert1 = p_111196_;
            this.vert2 = p_111197_;
            this.vert3 = p_111198_;
        }

        public static AmbientVertexRemap fromFacing(Direction pFacing) {
            return BY_FACING[pFacing.get3DDataValue()];
        }
    }

    static class Cache {
        private boolean enabled;
        private final Long2IntLinkedOpenHashMap colorCache = Util.make(() -> {
            Long2IntLinkedOpenHashMap long2intlinkedopenhashmap = new Long2IntLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_111238_) {
                }
            };
            long2intlinkedopenhashmap.defaultReturnValue(Integer.MAX_VALUE);
            return long2intlinkedopenhashmap;
        });
        private final Long2FloatLinkedOpenHashMap brightnessCache = Util.make(() -> {
            Long2FloatLinkedOpenHashMap long2floatlinkedopenhashmap = new Long2FloatLinkedOpenHashMap(100, 0.25f){

                protected void rehash(int p_111245_) {
                }
            };
            long2floatlinkedopenhashmap.defaultReturnValue(Float.NaN);
            return long2floatlinkedopenhashmap;
        });

        private Cache() {
        }

        public void enable() {
            this.enabled = true;
        }

        public void disable() {
            this.enabled = false;
            this.colorCache.clear();
            this.brightnessCache.clear();
        }

        public int getLightColor(BlockState pState, BlockAndTintGetter pLevel, BlockPos pPos) {
            int j;
            long i = pPos.asLong();
            if (this.enabled && (j = this.colorCache.get(i)) != Integer.MAX_VALUE) {
                return j;
            }
            int k = LevelRenderer.getLightColor(pLevel, pState, pPos);
            if (this.enabled) {
                if (this.colorCache.size() == 100) {
                    this.colorCache.removeFirstInt();
                }
                this.colorCache.put(i, k);
            }
            return k;
        }

        public float getShadeBrightness(BlockState pState, BlockAndTintGetter pLevel, BlockPos pPos) {
            float f;
            long i = pPos.asLong();
            if (this.enabled && !Float.isNaN(f = this.brightnessCache.get(i))) {
                return f;
            }
            float f1 = pState.getShadeBrightness(pLevel, pPos);
            if (this.enabled) {
                if (this.brightnessCache.size() == 100) {
                    this.brightnessCache.removeFirstFloat();
                }
                this.brightnessCache.put(i, f1);
            }
            return f1;
        }
    }

    protected static enum SizeInfo {
        DOWN(Direction.DOWN, false),
        UP(Direction.UP, false),
        NORTH(Direction.NORTH, false),
        SOUTH(Direction.SOUTH, false),
        WEST(Direction.WEST, false),
        EAST(Direction.EAST, false),
        FLIP_DOWN(Direction.DOWN, true),
        FLIP_UP(Direction.UP, true),
        FLIP_NORTH(Direction.NORTH, true),
        FLIP_SOUTH(Direction.SOUTH, true),
        FLIP_WEST(Direction.WEST, true),
        FLIP_EAST(Direction.EAST, true);

        final int shape;

        private SizeInfo(Direction p_111264_, boolean p_111265_) {
            this.shape = p_111264_.get3DDataValue() + (p_111265_ ? DIRECTIONS.length : 0);
        }
    }
}

