/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.IVertexProducer;
import net.optifine.Config;
import net.optifine.model.BakedQuadRetextured;
import net.optifine.model.QuadBounds;
import net.optifine.reflect.Reflector;
import net.optifine.render.QuadVertexPositions;
import net.optifine.render.VertexPosition;

public class BakedQuad
implements IVertexProducer {
    protected int[] vertices;
    protected final int tintIndex;
    protected Direction direction;
    protected TextureAtlasSprite sprite;
    private final boolean shade;
    private int[] vertexDataSingle = null;
    private QuadBounds quadBounds;
    private boolean quadEmissiveChecked;
    private BakedQuad quadEmissive;
    private QuadVertexPositions quadVertexPositions;

    public BakedQuad(int[] pVertices, int pTintIndex, Direction pDirection, TextureAtlasSprite pSprite, boolean pShade) {
        this.vertices = pVertices;
        this.tintIndex = pTintIndex;
        this.direction = pDirection;
        this.sprite = pSprite;
        this.shade = pShade;
        this.fixVertexData();
    }

    public TextureAtlasSprite getSprite() {
        if (this.sprite == null) {
            this.sprite = BakedQuad.getSpriteByUv(this.getVertices());
        }
        return this.sprite;
    }

    public int[] getVertices() {
        this.fixVertexData();
        return this.vertices;
    }

    public boolean isTinted() {
        return this.tintIndex != -1;
    }

    public int getTintIndex() {
        return this.tintIndex;
    }

    public Direction getDirection() {
        if (this.direction == null) {
            this.direction = FaceBakery.a(this.getVertices());
        }
        return this.direction;
    }

    public boolean isShade() {
        return this.shade;
    }

    public int[] getVertexDataSingle() {
        if (this.vertexDataSingle == null) {
            this.vertexDataSingle = BakedQuad.makeVertexDataSingle(this.getVertices(), this.getSprite());
        }
        if (this.vertexDataSingle.length != this.getVertices().length) {
            this.vertexDataSingle = BakedQuad.makeVertexDataSingle(this.getVertices(), this.getSprite());
        }
        return this.vertexDataSingle;
    }

    private static int[] makeVertexDataSingle(int[] vd, TextureAtlasSprite sprite) {
        int[] aint = (int[])vd.clone();
        int i = aint.length / 4;
        int j = 0;
        while (j < 4) {
            int k = j * i;
            float f = Float.intBitsToFloat(aint[k + 4]);
            float f1 = Float.intBitsToFloat(aint[k + 4 + 1]);
            float f2 = sprite.toSingleU(f);
            float f3 = sprite.toSingleV(f1);
            aint[k + 4] = Float.floatToRawIntBits(f2);
            aint[k + 4 + 1] = Float.floatToRawIntBits(f3);
            ++j;
        }
        return aint;
    }

    @Override
    public void pipe(IVertexConsumer consumer) {
        Reflector.callVoid(Reflector.LightUtil_putBakedQuad, consumer, this);
    }

    private static TextureAtlasSprite getSpriteByUv(int[] vertexData) {
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int i = vertexData.length / 4;
        int j = 0;
        while (j < 4) {
            int k = j * i;
            float f4 = Float.intBitsToFloat(vertexData[k + 4]);
            float f5 = Float.intBitsToFloat(vertexData[k + 4 + 1]);
            f = Math.min(f, f4);
            f1 = Math.min(f1, f5);
            f2 = Math.max(f2, f4);
            f3 = Math.max(f3, f5);
            ++j;
        }
        float f6 = (f + f2) / 2.0f;
        float f7 = (f1 + f3) / 2.0f;
        return Config.getTextureMap().getIconByUV(f6, f7);
    }

    protected void fixVertexData() {
        if (Config.isShaders()) {
            if (this.vertices.length == DefaultVertexFormat.BLOCK_VANILLA_SIZE) {
                this.vertices = BakedQuad.fixVertexDataSize(this.vertices, DefaultVertexFormat.BLOCK_SHADERS_SIZE);
            }
        } else if (this.vertices.length == DefaultVertexFormat.BLOCK_SHADERS_SIZE) {
            this.vertices = BakedQuad.fixVertexDataSize(this.vertices, DefaultVertexFormat.BLOCK_VANILLA_SIZE);
        }
    }

    private static int[] fixVertexDataSize(int[] vd, int sizeNew) {
        int i = vd.length / 4;
        int j = sizeNew / 4;
        int[] aint = new int[j * 4];
        int k = 0;
        while (k < 4) {
            int l = Math.min(i, j);
            System.arraycopy(vd, k * i, aint, k * j, l);
            ++k;
        }
        return aint;
    }

    public QuadBounds getQuadBounds() {
        if (this.quadBounds == null) {
            this.quadBounds = new QuadBounds(this.getVertices());
        }
        return this.quadBounds;
    }

    public float getMidX() {
        QuadBounds quadbounds = this.getQuadBounds();
        return (quadbounds.getMaxX() + quadbounds.getMinX()) / 2.0f;
    }

    public double getMidY() {
        QuadBounds quadbounds = this.getQuadBounds();
        return (quadbounds.getMaxY() + quadbounds.getMinY()) / 2.0f;
    }

    public double getMidZ() {
        QuadBounds quadbounds = this.getQuadBounds();
        return (quadbounds.getMaxZ() + quadbounds.getMinZ()) / 2.0f;
    }

    public boolean isFaceQuad() {
        QuadBounds quadbounds = this.getQuadBounds();
        return quadbounds.isFaceQuad(this.direction);
    }

    public boolean isFullQuad() {
        QuadBounds quadbounds = this.getQuadBounds();
        return quadbounds.isFullQuad(this.direction);
    }

    public boolean isFullFaceQuad() {
        return this.isFullQuad() && this.isFaceQuad();
    }

    public BakedQuad getQuadEmissive() {
        if (this.quadEmissiveChecked) {
            return this.quadEmissive;
        }
        if (this.quadEmissive == null && this.sprite != null && this.sprite.spriteEmissive != null) {
            this.quadEmissive = new BakedQuadRetextured(this, this.sprite.spriteEmissive);
        }
        this.quadEmissiveChecked = true;
        return this.quadEmissive;
    }

    public VertexPosition[] getVertexPositions(int key) {
        if (this.quadVertexPositions == null) {
            this.quadVertexPositions = new QuadVertexPositions();
        }
        return (VertexPosition[])this.quadVertexPositions.get(key);
    }

    public String toString() {
        return "vertexData: " + this.vertices.length + ", tint: " + this.tintIndex + ", facing: " + this.direction + ", sprite: " + this.sprite;
    }
}

