/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Vector3f;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.core.Direction;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;

public class BlockElement {
    private static final boolean DEFAULT_RESCALE = false;
    private static final float MIN_EXTENT = -16.0f;
    private static final float MAX_EXTENT = 32.0f;
    public final Vector3f from;
    public final Vector3f to;
    public final Map<Direction, BlockElementFace> faces;
    public final BlockElementRotation rotation;
    public final boolean shade;

    public BlockElement(Vector3f pFrom, Vector3f pTo, Map<Direction, BlockElementFace> pFaces, @Nullable BlockElementRotation pRotation, boolean pShade) {
        this.from = pFrom;
        this.to = pTo;
        this.faces = pFaces;
        this.rotation = pRotation;
        this.shade = pShade;
        this.fillUvs();
    }

    private void fillUvs() {
        for (Map.Entry<Direction, BlockElementFace> entry : this.faces.entrySet()) {
            float[] afloat = this.uvsByFace(entry.getKey());
            entry.getValue().uv.a(afloat);
        }
    }

    private float[] uvsByFace(Direction pFace) {
        switch (pFace) {
            case DOWN: {
                return new float[]{this.from.x(), 16.0f - this.to.z(), this.to.x(), 16.0f - this.from.z()};
            }
            case UP: {
                return new float[]{this.from.x(), this.from.z(), this.to.x(), this.to.z()};
            }
            default: {
                return new float[]{16.0f - this.to.x(), 16.0f - this.to.y(), 16.0f - this.from.x(), 16.0f - this.from.y()};
            }
            case SOUTH: {
                return new float[]{this.from.x(), 16.0f - this.to.y(), this.to.x(), 16.0f - this.from.y()};
            }
            case WEST: {
                return new float[]{this.from.z(), 16.0f - this.to.y(), this.to.z(), 16.0f - this.from.y()};
            }
            case EAST: 
        }
        return new float[]{16.0f - this.to.z(), 16.0f - this.to.y(), 16.0f - this.from.z(), 16.0f - this.from.y()};
    }

    protected static class Deserializer
    implements JsonDeserializer<BlockElement> {
        private static final boolean DEFAULT_SHADE = true;

        protected Deserializer() {
        }

        public BlockElement deserialize(JsonElement pJson, Type pType, JsonDeserializationContext pContext) throws JsonParseException {
            JsonObject jsonobject = pJson.getAsJsonObject();
            Vector3f vector3f = this.getFrom(jsonobject);
            Vector3f vector3f1 = this.getTo(jsonobject);
            BlockElementRotation blockelementrotation = this.getRotation(jsonobject);
            Map<Direction, BlockElementFace> map = this.getFaces(pContext, jsonobject);
            if (jsonobject.has("shade") && !GsonHelper.isBooleanValue(jsonobject, "shade")) {
                throw new JsonParseException("Expected shade to be a Boolean");
            }
            boolean flag = GsonHelper.getAsBoolean(jsonobject, "shade", true);
            return new BlockElement(vector3f, vector3f1, map, blockelementrotation, flag);
        }

        @Nullable
        private BlockElementRotation getRotation(JsonObject pJson) {
            BlockElementRotation blockelementrotation = null;
            if (pJson.has("rotation")) {
                JsonObject jsonobject = GsonHelper.getAsJsonObject(pJson, "rotation");
                Vector3f vector3f = this.getVector3f(jsonobject, "origin");
                vector3f.mul(0.0625f);
                Direction.Axis direction$axis = this.getAxis(jsonobject);
                float f = this.getAngle(jsonobject);
                boolean flag = GsonHelper.getAsBoolean(jsonobject, "rescale", false);
                blockelementrotation = new BlockElementRotation(vector3f, direction$axis, f, flag);
            }
            return blockelementrotation;
        }

        private float getAngle(JsonObject pJson) {
            float f = GsonHelper.getAsFloat(pJson, "angle");
            if (f != 0.0f && Mth.abs(f) != 22.5f && Mth.abs(f) != 45.0f) {
                throw new JsonParseException("Invalid rotation " + f + " found, only -45/-22.5/0/22.5/45 allowed");
            }
            return f;
        }

        private Direction.Axis getAxis(JsonObject pJson) {
            String s = GsonHelper.getAsString(pJson, "axis");
            Direction.Axis direction$axis = Direction.Axis.byName(s.toLowerCase(Locale.ROOT));
            if (direction$axis == null) {
                throw new JsonParseException("Invalid rotation axis: " + s);
            }
            return direction$axis;
        }

        private Map<Direction, BlockElementFace> getFaces(JsonDeserializationContext pContext, JsonObject pJson) {
            Map<Direction, BlockElementFace> map = this.filterNullFromFaces(pContext, pJson);
            if (map.isEmpty()) {
                throw new JsonParseException("Expected between 1 and 6 unique faces, got 0");
            }
            return map;
        }

        private Map<Direction, BlockElementFace> filterNullFromFaces(JsonDeserializationContext pContext, JsonObject pJson) {
            EnumMap map = Maps.newEnumMap(Direction.class);
            JsonObject jsonobject = GsonHelper.getAsJsonObject(pJson, "faces");
            for (Map.Entry entry : jsonobject.entrySet()) {
                Direction direction = this.getFacing((String)entry.getKey());
                map.put(direction, (BlockElementFace)pContext.deserialize((JsonElement)entry.getValue(), BlockElementFace.class));
            }
            return map;
        }

        private Direction getFacing(String pName) {
            Direction direction = Direction.byName(pName);
            if (direction == null) {
                throw new JsonParseException("Unknown facing: " + pName);
            }
            return direction;
        }

        private Vector3f getTo(JsonObject pJson) {
            Vector3f vector3f = this.getVector3f(pJson, "to");
            if (!(vector3f.x() < -16.0f || vector3f.y() < -16.0f || vector3f.z() < -16.0f || vector3f.x() > 32.0f || vector3f.y() > 32.0f || vector3f.z() > 32.0f)) {
                return vector3f;
            }
            throw new JsonParseException("'to' specifier exceeds the allowed boundaries: " + vector3f);
        }

        private Vector3f getFrom(JsonObject pJson) {
            Vector3f vector3f = this.getVector3f(pJson, "from");
            if (!(vector3f.x() < -16.0f || vector3f.y() < -16.0f || vector3f.z() < -16.0f || vector3f.x() > 32.0f || vector3f.y() > 32.0f || vector3f.z() > 32.0f)) {
                return vector3f;
            }
            throw new JsonParseException("'from' specifier exceeds the allowed boundaries: " + vector3f);
        }

        private Vector3f getVector3f(JsonObject pJson, String pName) {
            JsonArray jsonarray = GsonHelper.getAsJsonArray(pJson, pName);
            if (jsonarray.size() != 3) {
                throw new JsonParseException("Expected 3 " + pName + " values, found: " + jsonarray.size());
            }
            float[] afloat = new float[3];
            int i = 0;
            while (i < afloat.length) {
                afloat[i] = GsonHelper.convertToFloat(jsonarray.get(i), String.valueOf(pName) + "[" + i + "]");
                ++i;
            }
            return new Vector3f(afloat[0], afloat[1], afloat[2]);
        }
    }
}

