/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public class BlockModel
implements UnbakedModel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FaceBakery FACE_BAKERY = new FaceBakery();
    @VisibleForTesting
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new Deserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private static final char REFERENCE_CHAR = '#';
    public static final String PARTICLE_TEXTURE_REFERENCE = "particle";
    private final List<BlockElement> elements;
    @Nullable
    private final GuiLight guiLight;
    private final boolean hasAmbientOcclusion;
    private final ItemTransforms transforms;
    private final List<ItemOverride> overrides;
    public String name = "";
    @VisibleForTesting
    protected final Map<String, Either<Material, String>> textureMap;
    @Nullable
    protected BlockModel parent;
    @Nullable
    protected ResourceLocation parentLocation;

    public static BlockModel fromStream(Reader pReader) {
        return GsonHelper.fromJson(GSON, pReader, BlockModel.class);
    }

    public static BlockModel fromString(String pJsonString) {
        return BlockModel.fromStream(new StringReader(pJsonString));
    }

    public BlockModel(@Nullable ResourceLocation pParentLocation, List<BlockElement> pElements, Map<String, Either<Material, String>> pTextureMap, boolean pHasAmbientOcclusion, @Nullable GuiLight pGuiLight, ItemTransforms pTransforms, List<ItemOverride> pOverrides) {
        this.elements = pElements;
        this.hasAmbientOcclusion = pHasAmbientOcclusion;
        this.guiLight = pGuiLight;
        this.textureMap = pTextureMap;
        this.parentLocation = pParentLocation;
        this.transforms = pTransforms;
        this.overrides = pOverrides;
    }

    public List<BlockElement> getElements() {
        return this.elements.isEmpty() && this.parent != null ? this.parent.getElements() : this.elements;
    }

    public boolean hasAmbientOcclusion() {
        return this.parent != null ? this.parent.hasAmbientOcclusion() : this.hasAmbientOcclusion;
    }

    public GuiLight getGuiLight() {
        if (this.guiLight != null) {
            return this.guiLight;
        }
        return this.parent != null ? this.parent.getGuiLight() : GuiLight.SIDE;
    }

    public boolean isResolved() {
        return this.parentLocation == null || this.parent != null && this.parent.isResolved();
    }

    public List<ItemOverride> getOverrides() {
        return this.overrides;
    }

    private ItemOverrides getItemOverrides(ModelBakery pModelBakery, BlockModel pModel) {
        return this.overrides.isEmpty() ? ItemOverrides.EMPTY : new ItemOverrides(pModelBakery, pModel, pModelBakery::getModel, this.overrides);
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        HashSet set = Sets.newHashSet();
        for (ItemOverride itemoverride : this.overrides) {
            set.add(itemoverride.getModel());
        }
        if (this.parentLocation != null) {
            set.add(this.parentLocation);
        }
        return set;
    }

    @Override
    public Collection<Material> getMaterials(Function<ResourceLocation, UnbakedModel> pModelGetter, Set<Pair<String, String>> pMissingTextureErrors) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockModel blockmodel = this;
        while (blockmodel.parentLocation != null && blockmodel.parent == null) {
            set.add(blockmodel);
            UnbakedModel unbakedmodel = pModelGetter.apply(blockmodel.parentLocation);
            if (unbakedmodel == null) {
                LOGGER.warn("No parent '{}' while loading model '{}'", (Object)this.parentLocation, (Object)blockmodel);
            }
            if (set.contains(unbakedmodel)) {
                LOGGER.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", new Object[]{blockmodel, set.stream().map(Object::toString).collect(Collectors.joining(" -> ")), this.parentLocation});
                unbakedmodel = null;
            }
            if (unbakedmodel == null) {
                blockmodel.parentLocation = ModelBakery.MISSING_MODEL_LOCATION;
                unbakedmodel = pModelGetter.apply(blockmodel.parentLocation);
            }
            if (!(unbakedmodel instanceof BlockModel)) {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
            blockmodel = blockmodel.parent = (BlockModel)unbakedmodel;
        }
        HashSet set1 = Sets.newHashSet((Object[])new Material[]{this.getMaterial(PARTICLE_TEXTURE_REFERENCE)});
        for (BlockElement blockelement : this.getElements()) {
            for (BlockElementFace blockelementface : blockelement.faces.values()) {
                Material material = this.getMaterial(blockelementface.texture);
                if (Objects.equals(material.texture(), MissingTextureAtlasSprite.getLocation())) {
                    pMissingTextureErrors.add((Pair<String, String>)Pair.of((Object)blockelementface.texture, (Object)this.name));
                }
                set1.add(material);
            }
        }
        this.overrides.forEach(p_111475_ -> {
            UnbakedModel unbakedmodel1 = (UnbakedModel)pModelGetter.apply(p_111475_.getModel());
            if (!Objects.equals(unbakedmodel1, this)) {
                set1.addAll(unbakedmodel1.getMaterials(pModelGetter, pMissingTextureErrors));
            }
        });
        if (this.getRootModel() == ModelBakery.GENERATION_MARKER) {
            ItemModelGenerator.LAYERS.forEach(p_111467_ -> set1.add(this.getMaterial((String)p_111467_)));
        }
        return set1;
    }

    @Override
    public BakedModel bake(ModelBakery pModelBakery, Function<Material, TextureAtlasSprite> pSpriteGetter, ModelState pTransform, ResourceLocation pLocation) {
        return this.bake(pModelBakery, this, pSpriteGetter, pTransform, pLocation, true);
    }

    public BakedModel bake(ModelBakery pBakery, BlockModel pModel, Function<Material, TextureAtlasSprite> pSpriteGetter, ModelState pTransform, ResourceLocation pLocation, boolean pGuiLight3d) {
        TextureAtlasSprite textureatlassprite = pSpriteGetter.apply(this.getMaterial(PARTICLE_TEXTURE_REFERENCE));
        if (this.getRootModel() == ModelBakery.BLOCK_ENTITY_MARKER) {
            return new BuiltInModel(this.getTransforms(), this.getItemOverrides(pBakery, pModel), textureatlassprite, this.getGuiLight().lightLikeBlock());
        }
        SimpleBakedModel.Builder simplebakedmodel$builder = new SimpleBakedModel.Builder(this, this.getItemOverrides(pBakery, pModel), pGuiLight3d).particle(textureatlassprite);
        for (BlockElement blockelement : this.getElements()) {
            for (Direction direction : blockelement.faces.keySet()) {
                BlockElementFace blockelementface = blockelement.faces.get(direction);
                TextureAtlasSprite textureatlassprite1 = pSpriteGetter.apply(this.getMaterial(blockelementface.texture));
                if (blockelementface.cullForDirection == null) {
                    simplebakedmodel$builder.addUnculledFace(BlockModel.bakeFace(blockelement, blockelementface, textureatlassprite1, direction, pTransform, pLocation));
                    continue;
                }
                simplebakedmodel$builder.addCulledFace(Direction.rotate(pTransform.getRotation().getMatrix(), blockelementface.cullForDirection), BlockModel.bakeFace(blockelement, blockelementface, textureatlassprite1, direction, pTransform, pLocation));
            }
        }
        return simplebakedmodel$builder.build();
    }

    private static BakedQuad bakeFace(BlockElement pPart, BlockElementFace pPartFace, TextureAtlasSprite pSprite, Direction pDirection, ModelState pTransform, ResourceLocation pLocation) {
        return FACE_BAKERY.bakeQuad(pPart.from, pPart.to, pPartFace, pSprite, pDirection, pTransform, pPart.rotation, pPart.shade, pLocation);
    }

    public boolean hasTexture(String pTextureName) {
        return !MissingTextureAtlasSprite.getLocation().equals(this.getMaterial(pTextureName).texture());
    }

    public Material getMaterial(String pName) {
        if (BlockModel.isTextureReference(pName)) {
            pName = pName.substring(1);
        }
        ArrayList list = Lists.newArrayList();
        Either<Material, String> either;
        Optional optional;
        while (!(optional = (either = this.findTextureEntry(pName)).left()).isPresent()) {
            pName = (String)either.right().get();
            if (list.contains(pName)) {
                LOGGER.warn("Unable to resolve texture due to reference chain {}->{} in {}", new Object[]{Joiner.on((String)"->").join((Iterable)list), pName, this.name});
                return new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation());
            }
            list.add(pName);
        }
        return (Material)optional.get();
    }

    private Either<Material, String> findTextureEntry(String pName) {
        BlockModel blockmodel = this;
        while (blockmodel != null) {
            Either<Material, String> either = blockmodel.textureMap.get(pName);
            if (either != null) {
                return either;
            }
            blockmodel = blockmodel.parent;
        }
        return Either.left((Object)new Material(TextureAtlas.LOCATION_BLOCKS, MissingTextureAtlasSprite.getLocation()));
    }

    static boolean isTextureReference(String pStr) {
        return pStr.charAt(0) == '#';
    }

    public BlockModel getRootModel() {
        return this.parent == null ? this : this.parent.getRootModel();
    }

    public ItemTransforms getTransforms() {
        ItemTransform itemtransform = this.getTransform(ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ItemTransform itemtransform1 = this.getTransform(ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ItemTransform itemtransform2 = this.getTransform(ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ItemTransform itemtransform3 = this.getTransform(ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ItemTransform itemtransform4 = this.getTransform(ItemTransforms.TransformType.HEAD);
        ItemTransform itemtransform5 = this.getTransform(ItemTransforms.TransformType.GUI);
        ItemTransform itemtransform6 = this.getTransform(ItemTransforms.TransformType.GROUND);
        ItemTransform itemtransform7 = this.getTransform(ItemTransforms.TransformType.FIXED);
        return new ItemTransforms(itemtransform, itemtransform1, itemtransform2, itemtransform3, itemtransform4, itemtransform5, itemtransform6, itemtransform7);
    }

    private ItemTransform getTransform(ItemTransforms.TransformType pType) {
        return this.parent != null && !this.transforms.hasTransform(pType) ? this.parent.getTransform(pType) : this.transforms.getTransform(pType);
    }

    public String toString() {
        return this.name;
    }

    public static class Deserializer
    implements JsonDeserializer<BlockModel> {
        private static final boolean DEFAULT_AMBIENT_OCCLUSION = true;

        public BlockModel deserialize(JsonElement pJson, Type pType, JsonDeserializationContext pContext) throws JsonParseException {
            JsonObject jsonobject = pJson.getAsJsonObject();
            List<BlockElement> list = this.getElements(pContext, jsonobject);
            String s = this.getParentName(jsonobject);
            Map<String, Either<Material, String>> map = this.getTextureMap(jsonobject);
            boolean flag = this.getAmbientOcclusion(jsonobject);
            ItemTransforms itemtransforms = ItemTransforms.NO_TRANSFORMS;
            if (jsonobject.has("display")) {
                JsonObject jsonobject1 = GsonHelper.getAsJsonObject(jsonobject, "display");
                itemtransforms = (ItemTransforms)pContext.deserialize((JsonElement)jsonobject1, ItemTransforms.class);
            }
            List<ItemOverride> list1 = this.getOverrides(pContext, jsonobject);
            GuiLight blockmodel$guilight = null;
            if (jsonobject.has("gui_light")) {
                blockmodel$guilight = GuiLight.getByName(GsonHelper.getAsString(jsonobject, "gui_light"));
            }
            ResourceLocation resourcelocation = s.isEmpty() ? null : new ResourceLocation(s);
            return new BlockModel(resourcelocation, list, map, flag, blockmodel$guilight, itemtransforms, list1);
        }

        protected List<ItemOverride> getOverrides(JsonDeserializationContext pContext, JsonObject pJson) {
            ArrayList list = Lists.newArrayList();
            if (pJson.has("overrides")) {
                for (JsonElement jsonelement : GsonHelper.getAsJsonArray(pJson, "overrides")) {
                    list.add((ItemOverride)pContext.deserialize(jsonelement, ItemOverride.class));
                }
            }
            return list;
        }

        private Map<String, Either<Material, String>> getTextureMap(JsonObject pJson) {
            ResourceLocation resourcelocation = TextureAtlas.LOCATION_BLOCKS;
            HashMap map = Maps.newHashMap();
            if (pJson.has("textures")) {
                JsonObject jsonobject = GsonHelper.getAsJsonObject(pJson, "textures");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put((String)entry.getKey(), Deserializer.parseTextureLocationOrReference(resourcelocation, ((JsonElement)entry.getValue()).getAsString()));
                }
            }
            return map;
        }

        private static Either<Material, String> parseTextureLocationOrReference(ResourceLocation pLocation, String pName) {
            if (BlockModel.isTextureReference(pName)) {
                return Either.right((Object)pName.substring(1));
            }
            ResourceLocation resourcelocation = ResourceLocation.tryParse(pName);
            if (resourcelocation == null) {
                throw new JsonParseException(String.valueOf(pName) + " is not valid resource location");
            }
            return Either.left((Object)new Material(pLocation, resourcelocation));
        }

        private String getParentName(JsonObject pJson) {
            return GsonHelper.getAsString(pJson, "parent", "");
        }

        protected boolean getAmbientOcclusion(JsonObject pJson) {
            return GsonHelper.getAsBoolean(pJson, "ambientocclusion", true);
        }

        protected List<BlockElement> getElements(JsonDeserializationContext pContext, JsonObject pJson) {
            ArrayList list = Lists.newArrayList();
            if (pJson.has("elements")) {
                for (JsonElement jsonelement : GsonHelper.getAsJsonArray(pJson, "elements")) {
                    list.add((BlockElement)pContext.deserialize(jsonelement, BlockElement.class));
                }
            }
            return list;
        }
    }

    public static enum GuiLight {
        FRONT("front"),
        SIDE("side");

        private final String name;

        private GuiLight(String p_111525_) {
            this.name = p_111525_;
        }

        public static GuiLight getByName(String pName) {
            GuiLight[] guiLightArray = GuiLight.values();
            int n = guiLightArray.length;
            int n2 = 0;
            while (n2 < n) {
                GuiLight blockmodel$guilight = guiLightArray[n2];
                if (blockmodel$guilight.name.equals(pName)) {
                    return blockmodel$guilight;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Invalid gui light: " + pName);
        }

        public boolean lightLikeBlock() {
            return this == SIDE;
        }
    }

    public static class LoopException
    extends RuntimeException {
        public LoopException(String pMessage) {
            super(pMessage);
        }
    }
}

