/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.multipart.MultiPart;
import net.minecraft.client.renderer.block.model.multipart.Selector;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;

public class BlockModelDefinition {
    private final Map<String, MultiVariant> variants = Maps.newLinkedHashMap();
    private MultiPart multiPart;

    public static BlockModelDefinition fromStream(Context pContext, Reader pReader) {
        return GsonHelper.fromJson(pContext.gson, pReader, BlockModelDefinition.class);
    }

    public BlockModelDefinition(Map<String, MultiVariant> pVariants, MultiPart pMultiPart) {
        this.multiPart = pMultiPart;
        this.variants.putAll(pVariants);
    }

    public BlockModelDefinition(List<BlockModelDefinition> pModelDefinitions) {
        BlockModelDefinition blockmodeldefinition = null;
        for (BlockModelDefinition blockmodeldefinition1 : pModelDefinitions) {
            if (blockmodeldefinition1.isMultiPart()) {
                this.variants.clear();
                blockmodeldefinition = blockmodeldefinition1;
            }
            this.variants.putAll(blockmodeldefinition1.variants);
        }
        if (blockmodeldefinition != null) {
            this.multiPart = blockmodeldefinition.multiPart;
        }
    }

    @VisibleForTesting
    public boolean hasVariant(String pKey) {
        return this.variants.get(pKey) != null;
    }

    @VisibleForTesting
    public MultiVariant getVariant(String pKey) {
        MultiVariant multivariant = this.variants.get(pKey);
        if (multivariant == null) {
            throw new MissingVariantException();
        }
        return multivariant;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof BlockModelDefinition) {
            BlockModelDefinition blockmodeldefinition = (BlockModelDefinition)pOther;
            if (this.variants.equals(blockmodeldefinition.variants)) {
                return this.isMultiPart() ? this.multiPart.equals(blockmodeldefinition.multiPart) : !blockmodeldefinition.isMultiPart();
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.variants.hashCode() + (this.isMultiPart() ? this.multiPart.hashCode() : 0);
    }

    public Map<String, MultiVariant> getVariants() {
        return this.variants;
    }

    @VisibleForTesting
    public Set<MultiVariant> getMultiVariants() {
        HashSet set = Sets.newHashSet(this.variants.values());
        if (this.isMultiPart()) {
            set.addAll(this.multiPart.getMultiVariants());
        }
        return set;
    }

    public boolean isMultiPart() {
        return this.multiPart != null;
    }

    public MultiPart getMultiPart() {
        return this.multiPart;
    }

    public static final class Context {
        protected final Gson gson = new GsonBuilder().registerTypeAdapter(BlockModelDefinition.class, (Object)new Deserializer()).registerTypeAdapter(Variant.class, (Object)new Variant.Deserializer()).registerTypeAdapter(MultiVariant.class, (Object)new MultiVariant.Deserializer()).registerTypeAdapter(MultiPart.class, (Object)new MultiPart.Deserializer(this)).registerTypeAdapter(Selector.class, (Object)new Selector.Deserializer()).create();
        private StateDefinition<Block, BlockState> definition;

        public StateDefinition<Block, BlockState> getDefinition() {
            return this.definition;
        }

        public void setDefinition(StateDefinition<Block, BlockState> pStateContainer) {
            this.definition = pStateContainer;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<BlockModelDefinition> {
        public BlockModelDefinition deserialize(JsonElement pJson, Type pType, JsonDeserializationContext pContext) throws JsonParseException {
            JsonObject jsonobject = pJson.getAsJsonObject();
            Map<String, MultiVariant> map = this.getVariants(pContext, jsonobject);
            MultiPart multipart = this.getMultiPart(pContext, jsonobject);
            if (!map.isEmpty() || multipart != null && !multipart.getMultiVariants().isEmpty()) {
                return new BlockModelDefinition(map, multipart);
            }
            throw new JsonParseException("Neither 'variants' nor 'multipart' found");
        }

        protected Map<String, MultiVariant> getVariants(JsonDeserializationContext pContext, JsonObject pJson) {
            HashMap map = Maps.newHashMap();
            if (pJson.has("variants")) {
                JsonObject jsonobject = GsonHelper.getAsJsonObject(pJson, "variants");
                for (Map.Entry entry : jsonobject.entrySet()) {
                    map.put((String)entry.getKey(), (MultiVariant)pContext.deserialize((JsonElement)entry.getValue(), MultiVariant.class));
                }
            }
            return map;
        }

        @Nullable
        protected MultiPart getMultiPart(JsonDeserializationContext pContext, JsonObject pJson) {
            if (!pJson.has("multipart")) {
                return null;
            }
            JsonArray jsonarray = GsonHelper.getAsJsonArray(pJson, "multipart");
            return (MultiPart)pContext.deserialize((JsonElement)jsonarray, MultiPart.class);
        }
    }

    protected class MissingVariantException
    extends RuntimeException {
        protected MissingVariantException() {
        }
    }
}

