/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;

public class ItemModelGenerator {
    public static final List<String> LAYERS = Lists.newArrayList((Object[])new String[]{"layer0", "layer1", "layer2", "layer3", "layer4"});
    private static final float MIN_Z = 7.5f;
    private static final float MAX_Z = 8.5f;

    public BlockModel generateBlockModel(Function<Material, TextureAtlasSprite> pSpriteGetter, BlockModel pModel) {
        HashMap map = Maps.newHashMap();
        ArrayList list = Lists.newArrayList();
        int i = 0;
        while (i < LAYERS.size()) {
            String s = LAYERS.get(i);
            if (!pModel.hasTexture(s)) break;
            Material material = pModel.getMaterial(s);
            map.put(s, Either.left((Object)material));
            TextureAtlasSprite textureatlassprite = pSpriteGetter.apply(material);
            list.addAll(this.processFrames(i, s, textureatlassprite));
            ++i;
        }
        map.put("particle", pModel.hasTexture("particle") ? Either.left((Object)pModel.getMaterial("particle")) : (Either)map.get("layer0"));
        BlockModel blockmodel = new BlockModel(null, list, map, false, pModel.getGuiLight(), pModel.getTransforms(), pModel.getOverrides());
        blockmodel.name = pModel.name;
        return blockmodel;
    }

    private List<BlockElement> processFrames(int pTintIndex, String pTexture, TextureAtlasSprite pSprite) {
        HashMap map = Maps.newHashMap();
        map.put(Direction.SOUTH, new BlockElementFace(null, pTintIndex, pTexture, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)));
        map.put(Direction.NORTH, new BlockElementFace(null, pTintIndex, pTexture, new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        ArrayList list = Lists.newArrayList();
        list.add(new BlockElement(new Vector3f(0.0f, 0.0f, 7.5f), new Vector3f(16.0f, 16.0f, 8.5f), map, null, true));
        list.addAll(this.createSideElements(pSprite, pTexture, pTintIndex));
        return list;
    }

    private List<BlockElement> createSideElements(TextureAtlasSprite pSprite, String pTexture, int pTintIndex) {
        float f = pSprite.getWidth();
        float f1 = pSprite.getHeight();
        ArrayList list = Lists.newArrayList();
        for (Span itemmodelgenerator$span : this.getSpans(pSprite)) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            float f10 = 16.0f / f;
            float f11 = 16.0f / f1;
            float f12 = itemmodelgenerator$span.getMin();
            float f13 = itemmodelgenerator$span.getMax();
            float f14 = itemmodelgenerator$span.getAnchor();
            SpanFacing itemmodelgenerator$spanfacing = itemmodelgenerator$span.getFacing();
            switch (itemmodelgenerator$spanfacing) {
                case UP: {
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f8 = f14;
                    f3 = f14;
                    f5 = f14;
                    f9 = f14 + 1.0f;
                    break;
                }
                case DOWN: {
                    f8 = f14;
                    f9 = f14 + 1.0f;
                    f6 = f12;
                    f2 = f12;
                    f4 = f7 = f13 + 1.0f;
                    f3 = f14 + 1.0f;
                    f5 = f14 + 1.0f;
                    break;
                }
                case LEFT: {
                    f6 = f14;
                    f2 = f14;
                    f4 = f14;
                    f7 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                    break;
                }
                case RIGHT: {
                    f6 = f14;
                    f7 = f14 + 1.0f;
                    f2 = f14 + 1.0f;
                    f4 = f14 + 1.0f;
                    f9 = f12;
                    f3 = f12;
                    f5 = f8 = f13 + 1.0f;
                }
            }
            f2 *= f10;
            f4 *= f10;
            f3 *= f11;
            f5 *= f11;
            f3 = 16.0f - f3;
            f5 = 16.0f - f5;
            HashMap map = Maps.newHashMap();
            map.put(itemmodelgenerator$spanfacing.getDirection(), new BlockElementFace(null, pTintIndex, pTexture, new BlockFaceUV(new float[]{f6 *= f10, f8 *= f11, f7 *= f10, f9 *= f11}, 0)));
            switch (itemmodelgenerator$spanfacing) {
                case UP: {
                    list.add(new BlockElement(new Vector3f(f2, f3, 7.5f), new Vector3f(f4, f3, 8.5f), map, null, true));
                    break;
                }
                case DOWN: {
                    list.add(new BlockElement(new Vector3f(f2, f5, 7.5f), new Vector3f(f4, f5, 8.5f), map, null, true));
                    break;
                }
                case LEFT: {
                    list.add(new BlockElement(new Vector3f(f2, f3, 7.5f), new Vector3f(f2, f5, 8.5f), map, null, true));
                    break;
                }
                case RIGHT: {
                    list.add(new BlockElement(new Vector3f(f4, f3, 7.5f), new Vector3f(f4, f5, 8.5f), map, null, true));
                }
            }
        }
        return list;
    }

    private List<Span> getSpans(TextureAtlasSprite pSprite) {
        int i = pSprite.getWidth();
        int j = pSprite.getHeight();
        ArrayList list = Lists.newArrayList();
        pSprite.getUniqueFrames().forEach(p_173444_ -> {
            int k = 0;
            while (k < j) {
                int l = 0;
                while (l < i) {
                    boolean flag = !this.isTransparent(pSprite, p_173444_, l, k, i, j);
                    this.checkTransition(SpanFacing.UP, list, pSprite, p_173444_, l, k, i, j, flag);
                    this.checkTransition(SpanFacing.DOWN, list, pSprite, p_173444_, l, k, i, j, flag);
                    this.checkTransition(SpanFacing.LEFT, list, pSprite, p_173444_, l, k, i, j, flag);
                    this.checkTransition(SpanFacing.RIGHT, list, pSprite, p_173444_, l, k, i, j, flag);
                    ++l;
                }
                ++k;
            }
        });
        return list;
    }

    private void checkTransition(SpanFacing pSpanFacing, List<Span> pListSpans, TextureAtlasSprite pSprite, int pFrameIndex, int pPixelX, int pPixelY, int pSpiteWidth, int pSpriteHeight, boolean pTransparent) {
        boolean flag;
        boolean bl = flag = this.isTransparent(pSprite, pFrameIndex, pPixelX + pSpanFacing.getXOffset(), pPixelY + pSpanFacing.getYOffset(), pSpiteWidth, pSpriteHeight) && pTransparent;
        if (flag) {
            this.createOrExpandSpan(pListSpans, pSpanFacing, pPixelX, pPixelY);
        }
    }

    private void createOrExpandSpan(List<Span> pListSpans, SpanFacing pSpanFacing, int pPixelX, int pPixelY) {
        int k;
        Span itemmodelgenerator$span = null;
        for (Span itemmodelgenerator$span1 : pListSpans) {
            int i;
            if (itemmodelgenerator$span1.getFacing() != pSpanFacing) continue;
            int n = i = pSpanFacing.isHorizontal() ? pPixelY : pPixelX;
            if (itemmodelgenerator$span1.getAnchor() != i) continue;
            itemmodelgenerator$span = itemmodelgenerator$span1;
            break;
        }
        int j = pSpanFacing.isHorizontal() ? pPixelY : pPixelX;
        int n = k = pSpanFacing.isHorizontal() ? pPixelX : pPixelY;
        if (itemmodelgenerator$span == null) {
            pListSpans.add(new Span(pSpanFacing, k, j));
        } else {
            itemmodelgenerator$span.expand(k);
        }
    }

    private boolean isTransparent(TextureAtlasSprite pSprite, int pFrameIndex, int pPixelX, int pPixelY, int pSpiteWidth, int pSpriteHeight) {
        return pPixelX >= 0 && pPixelY >= 0 && pPixelX < pSpiteWidth && pPixelY < pSpriteHeight ? pSprite.isTransparent(pFrameIndex, pPixelX, pPixelY) : true;
    }

    static class Span {
        private final SpanFacing facing;
        private int min;
        private int max;
        private final int anchor;

        public Span(SpanFacing pFacing, int pMinMax, int pAnchor) {
            this.facing = pFacing;
            this.min = pMinMax;
            this.max = pMinMax;
            this.anchor = pAnchor;
        }

        public void expand(int pPos) {
            if (pPos < this.min) {
                this.min = pPos;
            } else if (pPos > this.max) {
                this.max = pPos;
            }
        }

        public SpanFacing getFacing() {
            return this.facing;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public int getAnchor() {
            return this.anchor;
        }
    }

    static enum SpanFacing {
        UP(Direction.UP, 0, -1),
        DOWN(Direction.DOWN, 0, 1),
        LEFT(Direction.EAST, -1, 0),
        RIGHT(Direction.WEST, 1, 0);

        private final Direction direction;
        private final int xOffset;
        private final int yOffset;

        private SpanFacing(Direction p_111701_, int p_111702_, int p_111703_) {
            this.direction = p_111701_;
            this.xOffset = p_111702_;
            this.yOffset = p_111703_;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        boolean isHorizontal() {
            return this == DOWN || this == UP;
        }
    }
}

