/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class ItemOverride {
    private final ResourceLocation model;
    private final List<Predicate> predicates;

    public ItemOverride(ResourceLocation pModel, List<Predicate> pPredicates) {
        this.model = pModel;
        this.predicates = ImmutableList.copyOf(pPredicates);
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public Stream<Predicate> getPredicates() {
        return this.predicates.stream();
    }

    protected static class Deserializer
    implements JsonDeserializer<ItemOverride> {
        protected Deserializer() {
        }

        public ItemOverride deserialize(JsonElement pJson, Type pType, JsonDeserializationContext pContext) throws JsonParseException {
            JsonObject jsonobject = pJson.getAsJsonObject();
            ResourceLocation resourcelocation = new ResourceLocation(GsonHelper.getAsString(jsonobject, "model"));
            List<Predicate> list = this.getPredicates(jsonobject);
            return new ItemOverride(resourcelocation, list);
        }

        protected List<Predicate> getPredicates(JsonObject pJson) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            JsonObject jsonobject = GsonHelper.getAsJsonObject(pJson, "predicate");
            for (Map.Entry entry : jsonobject.entrySet()) {
                map.put(new ResourceLocation((String)entry.getKey()), Float.valueOf(GsonHelper.convertToFloat((JsonElement)entry.getValue(), (String)entry.getKey())));
            }
            return (List)map.entrySet().stream().map(p_173453_ -> new Predicate((ResourceLocation)p_173453_.getKey(), ((Float)p_173453_.getValue()).floatValue())).collect(ImmutableList.toImmutableList());
        }
    }

    public static class Predicate {
        private final ResourceLocation property;
        private final float value;

        public Predicate(ResourceLocation pProperty, float pValue) {
            this.property = pProperty;
            this.value = pValue;
        }

        public ResourceLocation getProperty() {
            return this.property;
        }

        public float getValue() {
            return this.value;
        }
    }
}

