/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.optifine.Config;
import net.optifine.ItemOverrideCache;

public class ItemOverrides {
    public static final ItemOverrides EMPTY = new ItemOverrides();
    private final BakedOverride[] overrides;
    private final ResourceLocation[] properties;
    private ItemOverrideCache itemOverrideCache;
    public static ResourceLocation lastModelLocation = null;

    private ItemOverrides() {
        this.overrides = new BakedOverride[0];
        this.properties = new ResourceLocation[0];
    }

    public ItemOverrides(ModelBakery pBakery, BlockModel pModel, Function<ResourceLocation, UnbakedModel> pModelGetter, List<ItemOverride> pOverrides) {
        this(pBakery, pModel, pModelGetter, pBakery.getSpriteMap()::getSprite, pOverrides);
    }

    public ItemOverrides(ModelBakery modelBakeryIn, UnbakedModel blockModelIn, Function<ResourceLocation, UnbakedModel> modelGetter, Function<Material, TextureAtlasSprite> textureGetter, List<ItemOverride> itemOverridesIn) {
        this.properties = (ResourceLocation[])itemOverridesIn.stream().flatMap(ItemOverride::getPredicates).map(ItemOverride.Predicate::getProperty).distinct().toArray(ResourceLocation[]::new);
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        int i = 0;
        while (i < this.properties.length) {
            object2intmap.put((Object)this.properties[i], i);
            ++i;
        }
        ArrayList list = Lists.newArrayList();
        int j = itemOverridesIn.size() - 1;
        while (j >= 0) {
            ItemOverride itemoverride = itemOverridesIn.get(j);
            BakedModel bakedmodel = this.bakeModel(modelBakeryIn, blockModelIn, modelGetter, textureGetter, itemoverride);
            PropertyMatcher[] aitemoverrides$propertymatcher = (PropertyMatcher[])itemoverride.getPredicates().map(arg_0 -> ItemOverrides.lambda$4((Object2IntMap)object2intmap, arg_0)).toArray(PropertyMatcher[]::new);
            list.add(new BakedOverride(aitemoverrides$propertymatcher, bakedmodel));
            BakedOverride itemoverrides$bakedoverride = (BakedOverride)list.get(list.size() - 1);
            itemoverrides$bakedoverride.location = itemoverride.getModel();
            --j;
        }
        this.overrides = list.toArray(new BakedOverride[0]);
        if (itemOverridesIn.size() > 65) {
            this.itemOverrideCache = ItemOverrideCache.make(itemOverridesIn);
        }
    }

    @Nullable
    private BakedModel bakeModel(ModelBakery modelBakeryIn, UnbakedModel blockModelIn, Function<ResourceLocation, UnbakedModel> unbakedLocatorIn, Function<Material, TextureAtlasSprite> textureGetter, ItemOverride itemOverrideIn) {
        UnbakedModel unbakedmodel = unbakedLocatorIn.apply(itemOverrideIn.getModel());
        return Objects.equals(unbakedmodel, blockModelIn) ? null : modelBakeryIn.bake(itemOverrideIn.getModel(), BlockModelRotation.X0_Y0, textureGetter);
    }

    @Nullable
    public BakedModel resolve(BakedModel pModel, ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
        boolean flag = Config.isCustomItems();
        if (flag) {
            lastModelLocation = null;
        }
        if (this.overrides.length != 0) {
            Integer integer;
            if (this.itemOverrideCache != null && (integer = this.itemOverrideCache.getModelIndex(pStack, pLevel, pEntity)) != null) {
                int k = integer;
                if (k >= 0 && k < this.overrides.length) {
                    BakedModel bakedmodel;
                    if (flag) {
                        lastModelLocation = this.overrides[k].location;
                    }
                    if ((bakedmodel = this.overrides[k].model) != null) {
                        return bakedmodel;
                    }
                }
                return pModel;
            }
            Item item = pStack.getItem();
            int i = this.properties.length;
            float[] afloat = new float[i];
            int j = 0;
            while (j < i) {
                ResourceLocation resourcelocation = this.properties[j];
                ItemPropertyFunction itempropertyfunction = ItemProperties.getProperty(item, resourcelocation);
                afloat[j] = itempropertyfunction != null ? itempropertyfunction.call(pStack, pLevel, pEntity, pSeed) : Float.NEGATIVE_INFINITY;
                ++j;
            }
            int l = 0;
            while (l < this.overrides.length) {
                BakedOverride itemoverrides$bakedoverride = this.overrides[l];
                if (itemoverrides$bakedoverride.a(afloat)) {
                    BakedModel bakedmodel1 = itemoverrides$bakedoverride.model;
                    if (flag) {
                        lastModelLocation = itemoverrides$bakedoverride.location;
                    }
                    if (this.itemOverrideCache != null) {
                        this.itemOverrideCache.putModelIndex(pStack, pLevel, pEntity, l);
                    }
                    if (bakedmodel1 == null) {
                        return pModel;
                    }
                    return bakedmodel1;
                }
                ++l;
            }
        }
        return pModel;
    }

    private static /* synthetic */ PropertyMatcher lambda$4(Object2IntMap object2IntMap, ItemOverride.Predicate p_173475_1_) {
        int k = object2IntMap.getInt((Object)p_173475_1_.getProperty());
        return new PropertyMatcher(k, p_173475_1_.getValue());
    }

    static class BakedOverride {
        private final PropertyMatcher[] matchers;
        @Nullable
        final BakedModel model;
        private ResourceLocation location;

        BakedOverride(PropertyMatcher[] pMatchers, @Nullable BakedModel pModel) {
            this.matchers = pMatchers;
            this.model = pModel;
        }

        boolean a(float[] p_173486_) {
            PropertyMatcher[] propertyMatcherArray = this.matchers;
            int n = this.matchers.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyMatcher itemoverrides$propertymatcher = propertyMatcherArray[n2];
                float f = p_173486_[itemoverrides$propertymatcher.index];
                if (f < itemoverrides$propertymatcher.value) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    static class PropertyMatcher {
        public final int index;
        public final float value;

        PropertyMatcher(int pIndex, float pValue) {
            this.index = pIndex;
            this.value = pValue;
        }
    }
}

