/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.lang.reflect.Type;
import net.minecraft.util.GsonHelper;

public class ItemTransform {
    public static final ItemTransform NO_TRANSFORM = new ItemTransform(new Vector3f(), new Vector3f(), new Vector3f(1.0f, 1.0f, 1.0f));
    public final Vector3f rotation;
    public final Vector3f translation;
    public final Vector3f scale;

    public ItemTransform(Vector3f pRotation, Vector3f pTranslation, Vector3f pScale) {
        this.rotation = pRotation.copy();
        this.translation = pTranslation.copy();
        this.scale = pScale.copy();
    }

    public void apply(boolean pLeftHand, PoseStack pPoseStack) {
        if (this != NO_TRANSFORM) {
            float f = this.rotation.x();
            float f1 = this.rotation.y();
            float f2 = this.rotation.z();
            if (pLeftHand) {
                f1 = -f1;
                f2 = -f2;
            }
            int i = pLeftHand ? -1 : 1;
            pPoseStack.translate((float)i * this.translation.x(), this.translation.y(), this.translation.z());
            pPoseStack.mulPose(new Quaternion(f, f1, f2, true));
            pPoseStack.scale(this.scale.x(), this.scale.y(), this.scale.z());
        }
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (this.getClass() != pOther.getClass()) {
            return false;
        }
        ItemTransform itemtransform = (ItemTransform)pOther;
        return this.rotation.equals(itemtransform.rotation) && this.scale.equals(itemtransform.scale) && this.translation.equals(itemtransform.translation);
    }

    public int hashCode() {
        int i = this.rotation.hashCode();
        i = 31 * i + this.translation.hashCode();
        return 31 * i + this.scale.hashCode();
    }

    protected static class Deserializer
    implements JsonDeserializer<ItemTransform> {
        private static final Vector3f DEFAULT_ROTATION = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f DEFAULT_TRANSLATION = new Vector3f(0.0f, 0.0f, 0.0f);
        private static final Vector3f DEFAULT_SCALE = new Vector3f(1.0f, 1.0f, 1.0f);
        public static final float MAX_TRANSLATION = 5.0f;
        public static final float MAX_SCALE = 4.0f;

        protected Deserializer() {
        }

        public ItemTransform deserialize(JsonElement pJson, Type pType, JsonDeserializationContext pContext) throws JsonParseException {
            JsonObject jsonobject = pJson.getAsJsonObject();
            Vector3f vector3f = this.getVector3f(jsonobject, "rotation", DEFAULT_ROTATION);
            Vector3f vector3f1 = this.getVector3f(jsonobject, "translation", DEFAULT_TRANSLATION);
            vector3f1.mul(0.0625f);
            vector3f1.clamp(-5.0f, 5.0f);
            Vector3f vector3f2 = this.getVector3f(jsonobject, "scale", DEFAULT_SCALE);
            vector3f2.clamp(-4.0f, 4.0f);
            return new ItemTransform(vector3f, vector3f1, vector3f2);
        }

        private Vector3f getVector3f(JsonObject pJson, String pKey, Vector3f pFallback) {
            if (!pJson.has(pKey)) {
                return pFallback;
            }
            JsonArray jsonarray = GsonHelper.getAsJsonArray(pJson, pKey);
            if (jsonarray.size() != 3) {
                throw new JsonParseException("Expected 3 " + pKey + " values, found: " + jsonarray.size());
            }
            float[] afloat = new float[3];
            int i = 0;
            while (i < afloat.length) {
                afloat[i] = GsonHelper.convertToFloat(jsonarray.get(i), String.valueOf(pKey) + "[" + i + "]");
                ++i;
            }
            return new Vector3f(afloat[0], afloat[1], afloat[2]);
        }
    }
}

