/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model.multipart;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.multipart.Condition;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class KeyValueCondition
implements Condition {
    private static final Splitter PIPE_SPLITTER = Splitter.on((char)'|').omitEmptyStrings();
    private final String key;
    private final String value;

    public KeyValueCondition(String pKey, String pValue) {
        this.key = pKey;
        this.value = pValue;
    }

    @Override
    public Predicate<BlockState> getPredicate(StateDefinition<Block, BlockState> pDefinition) {
        Predicate<BlockState> predicate;
        List list;
        boolean flag;
        Property<?> property = pDefinition.getProperty(this.key);
        if (property == null) {
            throw new RuntimeException(String.format("Unknown property '%s' on '%s'", this.key, pDefinition.getOwner()));
        }
        String s = this.value;
        boolean bl = flag = !s.isEmpty() && s.charAt(0) == '!';
        if (flag) {
            s = s.substring(1);
        }
        if ((list = PIPE_SPLITTER.splitToList((CharSequence)s)).isEmpty()) {
            throw new RuntimeException(String.format("Empty value '%s' for property '%s' on '%s'", this.value, this.key, pDefinition.getOwner()));
        }
        if (list.size() == 1) {
            predicate = this.getBlockStatePredicate(pDefinition, property, s);
        } else {
            List list1 = list.stream().map(p_111958_ -> this.getBlockStatePredicate(pDefinition, property, (String)p_111958_)).collect(Collectors.toList());
            predicate = p_111954_ -> list1.stream().anyMatch(p_173509_ -> p_173509_.test(p_111954_));
        }
        return flag ? predicate.negate() : predicate;
    }

    private Predicate<BlockState> getBlockStatePredicate(StateDefinition<Block, BlockState> pDefinition, Property<?> pProperty, String pValue) {
        Optional<?> optional = pProperty.getValue(pValue);
        if (!optional.isPresent()) {
            throw new RuntimeException(String.format("Unknown value '%s' for property '%s' on '%s' in '%s'", pValue, this.key, pDefinition.getOwner(), this.value));
        }
        return p_111951_ -> p_111951_.getValue(pProperty).equals(optional.get());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }
}

