/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.BlockState;

public class BannerRenderer
implements BlockEntityRenderer<BannerBlockEntity> {
    private static final int BANNER_WIDTH = 20;
    private static final int BANNER_HEIGHT = 40;
    private static final int MAX_PATTERNS = 16;
    public static final String FLAG = "flag";
    private static final String POLE = "pole";
    private static final String BAR = "bar";
    private final ModelPart flag;
    private final ModelPart pole;
    private final ModelPart bar;

    public BannerRenderer(BlockEntityRendererProvider.Context pContext) {
        ModelPart modelpart = pContext.bakeLayer(ModelLayers.BANNER);
        this.flag = modelpart.getChilds(FLAG);
        this.pole = modelpart.getChilds(POLE);
        this.bar = modelpart.getChilds(BAR);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild(FLAG, CubeListBuilder.create().texOffs(0, 0).addBox(-10.0f, 0.0f, -2.0f, 20.0f, 40.0f, 1.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(POLE, CubeListBuilder.create().texOffs(44, 0).addBox(-1.0f, -30.0f, -1.0f, 2.0f, 42.0f, 2.0f), PartPose.ZERO);
        partdefinition.addOrReplaceChild(BAR, CubeListBuilder.create().texOffs(0, 42).addBox(-10.0f, -32.0f, -1.0f, 20.0f, 2.0f, 2.0f), PartPose.ZERO);
        return LayerDefinition.create(meshdefinition, 64, 64);
    }

    @Override
    public void render(BannerBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        long i;
        List<Pair<BannerPattern, DyeColor>> list = pBlockEntity.getPatterns();
        float f = 0.6666667f;
        boolean flag = pBlockEntity.getLevel() == null;
        pPoseStack.pushPose();
        if (flag) {
            i = 0L;
            pPoseStack.translate(0.5, 0.5, 0.5);
            this.pole.visible = true;
        } else {
            i = pBlockEntity.getLevel().getGameTime();
            BlockState blockstate = pBlockEntity.getBlockState();
            if (blockstate.getBlock() instanceof BannerBlock) {
                pPoseStack.translate(0.5, 0.5, 0.5);
                float f1 = (float)(-blockstate.getValue(BannerBlock.ROTATION).intValue() * 360) / 16.0f;
                pPoseStack.mulPose(Vector3f.YP.rotationDegrees(f1));
                this.pole.visible = true;
            } else {
                pPoseStack.translate(0.5, -0.1666666716337204, 0.5);
                float f3 = -blockstate.getValue(WallBannerBlock.FACING).toYRot();
                pPoseStack.mulPose(Vector3f.YP.rotationDegrees(f3));
                pPoseStack.translate(0.0, -0.3125, -0.4375);
                this.pole.visible = false;
            }
        }
        pPoseStack.pushPose();
        pPoseStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        VertexConsumer vertexconsumer = ModelBakery.BANNER_BASE.buffer(pBufferSource, RenderType::entitySolid);
        this.pole.render(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        this.bar.render(pPoseStack, vertexconsumer, pPackedLight, pPackedOverlay);
        BlockPos blockpos = pBlockEntity.getBlockPos();
        float f2 = ((float)Math.floorMod((long)(blockpos.getX() * 7 + blockpos.getY() * 9 + blockpos.getZ() * 13) + i, 100L) + pPartialTick) / 100.0f;
        this.flag.xRot = (-0.0125f + 0.01f * Mth.cos((float)Math.PI * 2 * f2)) * (float)Math.PI;
        this.flag.y = -32.0f;
        BannerRenderer.renderPatterns(pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, this.flag, ModelBakery.BANNER_BASE, true, list);
        pPoseStack.popPose();
        pPoseStack.popPose();
    }

    public static void renderPatterns(PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, ModelPart pFlagPart, Material pFlagMaterial, boolean pBanner, List<Pair<BannerPattern, DyeColor>> pPatterns) {
        BannerRenderer.renderPatterns(pPoseStack, pBufferSource, pPackedLight, pPackedOverlay, pFlagPart, pFlagMaterial, pBanner, pPatterns, false);
    }

    public static void renderPatterns(PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay, ModelPart pFlagPart, Material pFlagMaterial, boolean pBanner, List<Pair<BannerPattern, DyeColor>> pPatterns, boolean pGlint) {
        pFlagPart.render(pPoseStack, pFlagMaterial.buffer(pBufferSource, RenderType::entitySolid, pGlint), pPackedLight, pPackedOverlay);
        int i = 0;
        while (i < 17 && i < pPatterns.size()) {
            Pair<BannerPattern, DyeColor> pair = pPatterns.get(i);
            float[] afloat = ((DyeColor)pair.getSecond()).getTextureDiffuseColors();
            BannerPattern bannerpattern = (BannerPattern)((Object)pair.getFirst());
            Material material = pBanner ? Sheets.getBannerMaterial(bannerpattern) : Sheets.getShieldMaterial(bannerpattern);
            pFlagPart.render(pPoseStack, material.buffer(pBufferSource, RenderType::entityNoOutline), pPackedLight, pPackedOverlay, afloat[0], afloat[1], afloat[2], 1.0f);
            ++i;
        }
    }
}

