/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.IdentityHashMap;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public interface BlockEntityRenderer<T extends BlockEntity>
extends IEntityRenderer {
    public static final IdentityHashMap<BlockEntityRenderer, BlockEntityType> CACHED_TYPES = new IdentityHashMap();

    public void render(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);

    default public boolean shouldRenderOffScreen(T pBlockEntity) {
        return false;
    }

    default public int getViewDistance() {
        return 64;
    }

    default public boolean shouldRender(T pBlockEntity, Vec3 pCameraPos) {
        return Vec3.atCenterOf(((BlockEntity)pBlockEntity).getBlockPos()).closerThan(pCameraPos, this.getViewDistance());
    }

    @Override
    default public Either<EntityType, BlockEntityType> getType() {
        BlockEntityType blockentitytype = CACHED_TYPES.get(this);
        return blockentitytype == null ? null : Either.makeRight(blockentitytype);
    }

    @Override
    default public void setType(Either<EntityType, BlockEntityType> type) {
        CACHED_TYPES.put(this, type.getRight().get());
    }

    @Override
    default public ResourceLocation getLocationTextureCustom() {
        return null;
    }

    @Override
    default public void setLocationTextureCustom(ResourceLocation locationTextureCustom) {
    }
}

