/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;

public class PistonHeadRenderer
implements BlockEntityRenderer<PistonMovingBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public PistonHeadRenderer(BlockEntityRendererProvider.Context pContext) {
        this.blockRenderer = pContext.getBlockRenderDispatcher();
    }

    @Override
    public void render(PistonMovingBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Level level = pBlockEntity.getLevel();
        if (level != null) {
            BlockPos blockpos = pBlockEntity.getBlockPos().relative(pBlockEntity.getMovementDirection().getOpposite());
            BlockState blockstate = pBlockEntity.getMovedState();
            if (!blockstate.isAir()) {
                ModelBlockRenderer.enableCaching();
                pPoseStack.pushPose();
                pPoseStack.translate(pBlockEntity.getXOff(pPartialTick), pBlockEntity.getYOff(pPartialTick), pBlockEntity.getZOff(pPartialTick));
                if (blockstate.is(Blocks.PISTON_HEAD) && pBlockEntity.getProgress(pPartialTick) <= 4.0f) {
                    blockstate = (BlockState)blockstate.setValue(PistonHeadBlock.SHORT, pBlockEntity.getProgress(pPartialTick) <= 0.5f);
                    this.renderBlock(blockpos, blockstate, pPoseStack, pBufferSource, level, false, pPackedOverlay);
                } else if (pBlockEntity.isSourcePiston() && !pBlockEntity.isExtending()) {
                    PistonType pistontype = blockstate.is(Blocks.STICKY_PISTON) ? PistonType.STICKY : PistonType.DEFAULT;
                    BlockState blockstate1 = (BlockState)((BlockState)Blocks.PISTON_HEAD.defaultBlockState().setValue(PistonHeadBlock.TYPE, pistontype)).setValue(PistonHeadBlock.FACING, blockstate.getValue(PistonBaseBlock.FACING));
                    blockstate1 = (BlockState)blockstate1.setValue(PistonHeadBlock.SHORT, pBlockEntity.getProgress(pPartialTick) >= 0.5f);
                    this.renderBlock(blockpos, blockstate1, pPoseStack, pBufferSource, level, false, pPackedOverlay);
                    BlockPos blockpos1 = blockpos.relative(pBlockEntity.getMovementDirection());
                    pPoseStack.popPose();
                    pPoseStack.pushPose();
                    blockstate = (BlockState)blockstate.setValue(PistonBaseBlock.EXTENDED, true);
                    this.renderBlock(blockpos1, blockstate, pPoseStack, pBufferSource, level, true, pPackedOverlay);
                } else {
                    this.renderBlock(blockpos, blockstate, pPoseStack, pBufferSource, level, false, pPackedOverlay);
                }
                pPoseStack.popPose();
                ModelBlockRenderer.clearCache();
            }
        }
    }

    private void renderBlock(BlockPos pPos, BlockState pState, PoseStack pPoseStack, MultiBufferSource pBufferSource, Level pLevel, boolean pExtended, int pPackedOverlay) {
        RenderType rendertype = ItemBlockRenderTypes.getMovingBlockRenderType(pState);
        VertexConsumer vertexconsumer = pBufferSource.getBuffer(rendertype);
        this.blockRenderer.getModelRenderer().tesselateBlock(pLevel, this.blockRenderer.getBlockModel(pState), pState, pPos, pPoseStack, vertexconsumer, pExtended, new Random(), pState.getSeed(pPos), pPackedOverlay);
    }

    @Override
    public int getViewDistance() {
        return 68;
    }
}

